/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzfk;
import com.google.android.gms.internal.places.zzhb;
import com.google.android.gms.internal.places.zzhg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfp
extends zzfk<Boolean>
implements zzhg<Boolean>,
RandomAccess {
    private static final zzfp zznr = new zzfp();
    private boolean[] zzns;
    private int size;

    zzfp() {
        this(new boolean[10], 0);
    }

    private zzfp(boolean[] blArray, int n) {
        this.zzns = blArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbc();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzns, n2, this.zzns, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfp)) {
            return super.equals(object);
        }
        zzfp zzfp2 = (zzfp)object;
        if (this.size != zzfp2.size) {
            return false;
        }
        boolean[] blArray = zzfp2.zzns;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzns[i] == blArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzhb.zzf(this.zzns[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void addBoolean(boolean bl) {
        this.zzb(this.size, bl);
    }

    private final void zzb(int n, boolean bl) {
        this.zzbc();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
        if (this.size < this.zzns.length) {
            System.arraycopy(this.zzns, n, this.zzns, n + 1, this.size - n);
        } else {
            boolean[] blArray = new boolean[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzns, 0, blArray, 0, n);
            System.arraycopy(this.zzns, n, blArray, n + 1, this.size - n);
            this.zzns = blArray;
        }
        this.zzns[n] = bl;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Boolean> collection) {
        this.zzbc();
        zzhb.checkNotNull(collection);
        if (!(collection instanceof zzfp)) {
            return super.addAll(collection);
        }
        zzfp zzfp2 = (zzfp)collection;
        if (zzfp2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfp2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfp2.size;
        if (n > this.zzns.length) {
            this.zzns = Arrays.copyOf(this.zzns, n);
        }
        System.arraycopy(zzfp2.zzns, 0, this.zzns, this.size, zzfp2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbc();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzns[i])) continue;
            System.arraycopy(this.zzns, i + 1, this.zzns, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzac(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
    }

    private final String zzad(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Boolean bl = (Boolean)object;
        boolean bl2 = bl;
        zzfp zzfp2 = this;
        zzfp2.zzbc();
        zzfp2.zzac(n);
        boolean bl3 = zzfp2.zzns[n];
        zzfp2.zzns[n] = bl2;
        return bl3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfp zzfp2 = this;
        zzfp2.zzbc();
        zzfp2.zzac(n);
        boolean bl = zzfp2.zzns[n];
        if (n < zzfp2.size - 1) {
            System.arraycopy(zzfp2.zzns, n + 1, zzfp2.zzns, n, zzfp2.size - n);
        }
        --zzfp2.size;
        ++zzfp2.modCount;
        return bl;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Boolean bl = (Boolean)object;
        this.zzb(n, bl);
    }

    @Override
    public final /* synthetic */ zzhg zzae(int n) {
        int n2 = n;
        zzfp zzfp2 = this;
        if (n2 < zzfp2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfp(Arrays.copyOf(zzfp2.zzns, n2), zzfp2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfp zzfp2 = this;
        zzfp2.zzac(n);
        return zzfp2.zzns[n];
    }

    static {
        zznr.zzbb();
    }
}

