/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzfk;
import com.google.android.gms.internal.places.zzhb;
import com.google.android.gms.internal.places.zzhg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzgi
extends zzfk<Double>
implements zzhg<Double>,
RandomAccess {
    private static final zzgi zzoz = new zzgi();
    private double[] zzpa;
    private int size;

    zzgi() {
        this(new double[10], 0);
    }

    private zzgi(double[] dArray, int n) {
        this.zzpa = dArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbc();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzpa, n2, this.zzpa, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzgi)) {
            return super.equals(object);
        }
        zzgi zzgi2 = (zzgi)object;
        if (this.size != zzgi2.size) {
            return false;
        }
        double[] dArray = zzgi2.zzpa;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzpa[i] == dArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            long l = Double.doubleToLongBits(this.zzpa[i]);
            n = n * 31 + zzhb.zzo(l);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzd(double d) {
        this.zzd(this.size, d);
    }

    private final void zzd(int n, double d) {
        this.zzbc();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
        if (this.size < this.zzpa.length) {
            System.arraycopy(this.zzpa, n, this.zzpa, n + 1, this.size - n);
        } else {
            double[] dArray = new double[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzpa, 0, dArray, 0, n);
            System.arraycopy(this.zzpa, n, dArray, n + 1, this.size - n);
            this.zzpa = dArray;
        }
        this.zzpa[n] = d;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Double> collection) {
        this.zzbc();
        zzhb.checkNotNull(collection);
        if (!(collection instanceof zzgi)) {
            return super.addAll(collection);
        }
        zzgi zzgi2 = (zzgi)collection;
        if (zzgi2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzgi2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzgi2.size;
        if (n > this.zzpa.length) {
            this.zzpa = Arrays.copyOf(this.zzpa, n);
        }
        System.arraycopy(zzgi2.zzpa, 0, this.zzpa, this.size, zzgi2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbc();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzpa[i])) continue;
            System.arraycopy(this.zzpa, i + 1, this.zzpa, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzac(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
    }

    private final String zzad(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Double d = (Double)object;
        double d2 = d;
        zzgi zzgi2 = this;
        zzgi2.zzbc();
        zzgi2.zzac(n);
        double d3 = zzgi2.zzpa[n];
        zzgi2.zzpa[n] = d2;
        return d3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzgi zzgi2 = this;
        zzgi2.zzbc();
        zzgi2.zzac(n);
        double d = zzgi2.zzpa[n];
        if (n < zzgi2.size - 1) {
            System.arraycopy(zzgi2.zzpa, n + 1, zzgi2.zzpa, n, zzgi2.size - n);
        }
        --zzgi2.size;
        ++zzgi2.modCount;
        return d;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Double d = (Double)object;
        this.zzd(n, d);
    }

    @Override
    public final /* synthetic */ zzhg zzae(int n) {
        int n2 = n;
        zzgi zzgi2 = this;
        if (n2 < zzgi2.size) {
            throw new IllegalArgumentException();
        }
        return new zzgi(Arrays.copyOf(zzgi2.zzpa, n2), zzgi2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzgi zzgi2 = this;
        zzgi2.zzac(n);
        return zzgi2.zzpa[n];
    }

    static {
        zzoz.zzbb();
    }
}

