/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzfk;
import com.google.android.gms.internal.places.zzhb;
import com.google.android.gms.internal.places.zzhe;
import com.google.android.gms.internal.places.zzhg;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzha
extends zzfk<Integer>
implements zzhe,
RandomAccess {
    private static final zzha zztj = new zzha();
    private int[] zztk;
    private int size;

    public static zzha zzdy() {
        return zztj;
    }

    zzha() {
        this(new int[10], 0);
    }

    private zzha(int[] nArray, int n) {
        this.zztk = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzbc();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zztk, n2, this.zztk, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzha)) {
            return super.equals(object);
        }
        zzha zzha2 = (zzha)object;
        if (this.size != zzha2.size) {
            return false;
        }
        int[] nArray = zzha2.zztk;
        for (int i = 0; i < this.size; ++i) {
            if (this.zztk[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zztk[i];
        }
        return n;
    }

    @Override
    public final zzhe zzbd(int n) {
        if (n < this.size) {
            throw new IllegalArgumentException();
        }
        return new zzha(Arrays.copyOf(this.zztk, n), this.size);
    }

    public final int getInt(int n) {
        this.zzac(n);
        return this.zztk[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final void zzbe(int n) {
        this.zzq(this.size, n);
    }

    private final void zzq(int n, int n2) {
        this.zzbc();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
        if (this.size < this.zztk.length) {
            System.arraycopy(this.zztk, n, this.zztk, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zztk, 0, nArray, 0, n);
            System.arraycopy(this.zztk, n, nArray, n + 1, this.size - n);
            this.zztk = nArray;
        }
        this.zztk[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzbc();
        zzhb.checkNotNull(collection);
        if (!(collection instanceof zzha)) {
            return super.addAll(collection);
        }
        zzha zzha2 = (zzha)collection;
        if (zzha2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzha2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzha2.size;
        if (n > this.zztk.length) {
            this.zztk = Arrays.copyOf(this.zztk, n);
        }
        System.arraycopy(zzha2.zztk, 0, this.zztk, this.size, zzha2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzbc();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zztk[i])) continue;
            System.arraycopy(this.zztk, i + 1, this.zztk, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzac(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzad(n));
        }
    }

    private final String zzad(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzha zzha2 = this;
        zzha2.zzbc();
        zzha2.zzac(n);
        int n4 = zzha2.zztk[n];
        zzha2.zztk[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzha zzha2 = this;
        zzha2.zzbc();
        zzha2.zzac(n);
        int n2 = zzha2.zztk[n];
        if (n < zzha2.size - 1) {
            System.arraycopy(zzha2.zztk, n + 1, zzha2.zztk, n, zzha2.size - n);
        }
        --zzha2.size;
        ++zzha2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzq(n, n2);
    }

    @Override
    public final /* synthetic */ zzhg zzae(int n) {
        return this.zzbd(n);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zztj.zzbb();
    }
}

