/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzgf;
import com.google.android.gms.internal.places.zzih;
import com.google.android.gms.internal.places.zzkn;
import com.google.android.gms.internal.places.zzku;
import java.io.IOException;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.ReadOnlyBufferException;

public final class zzkm {
    private final ByteBuffer zzot;
    private zzgf zzaad;
    private int zzaae;

    private zzkm(byte[] byArray, int n, int n2) {
        this(ByteBuffer.wrap(byArray, n, n2));
    }

    private zzkm(ByteBuffer byteBuffer) {
        this.zzot = byteBuffer;
        this.zzot.order(ByteOrder.LITTLE_ENDIAN);
    }

    public static zzkm zzi(byte[] byArray) {
        return zzkm.zzl(byArray, 0, byArray.length);
    }

    public static zzkm zzl(byte[] byArray, int n, int n2) {
        return new zzkm(byArray, 0, n2);
    }

    private final zzgf zzhc() throws IOException {
        if (this.zzaad == null) {
            this.zzaad = zzgf.zzb(this.zzot);
            this.zzaae = this.zzot.position();
        } else if (this.zzaae != this.zzot.position()) {
            this.zzaad.write(this.zzot.array(), this.zzaae, this.zzot.position() - this.zzaae);
            this.zzaae = this.zzot.position();
        }
        return this.zzaad;
    }

    public final void zzb(int n, double d) throws IOException {
        this.zzd(n, 1);
        double d2 = d;
        long l = Double.doubleToLongBits(d2);
        zzkm zzkm2 = this;
        if (zzkm2.zzot.remaining() < 8) {
            throw new zzkn(zzkm2.zzot.position(), zzkm2.zzot.limit());
        }
        zzkm2.zzot.putLong(l);
    }

    public final void zzc(int n, float f) throws IOException {
        this.zzd(n, 5);
        float f2 = f;
        int n2 = Float.floatToIntBits(f2);
        zzkm zzkm2 = this;
        if (zzkm2.zzot.remaining() < 4) {
            throw new zzkn(zzkm2.zzot.position(), zzkm2.zzot.limit());
        }
        zzkm2.zzot.putInt(n2);
    }

    public final void zzj(int n, long l) throws IOException {
        this.zzd(n, 0);
        long l2 = l;
        this.zzq(l2);
    }

    public final void zze(int n, int n2) throws IOException {
        this.zzd(n, 0);
        int n3 = n2;
        zzkm zzkm2 = this;
        if (n3 >= 0) {
            zzkm2.zzbt(n3);
            return;
        }
        zzkm2.zzq(n3);
    }

    public final void zzb(int n, String string) throws IOException {
        this.zzd(n, 2);
        String string2 = string;
        zzkm zzkm2 = this;
        try {
            int n2 = zzkm.zzba(string2.length());
            int n3 = zzkm.zzba(string2.length() * 3);
            if (n2 == n3) {
                int n4 = zzkm2.zzot.position();
                if (zzkm2.zzot.remaining() < n2) {
                    throw new zzkn(n4 + n2, zzkm2.zzot.limit());
                }
                zzkm2.zzot.position(n4 + n2);
                zzkm.zze(string2, zzkm2.zzot);
                int n5 = zzkm2.zzot.position();
                zzkm2.zzot.position(n4);
                zzkm2.zzbt(n5 - n4 - n2);
                zzkm2.zzot.position(n5);
                return;
            }
            zzkm2.zzbt(zzkm.zzb(string2));
            zzkm.zze(string2, zzkm2.zzot);
            return;
        }
        catch (BufferOverflowException bufferOverflowException) {
            zzkn zzkn2 = new zzkn(zzkm2.zzot.position(), zzkm2.zzot.limit());
            zzkn2.initCause(bufferOverflowException);
            throw zzkn2;
        }
    }

    public final void zzb(int n, zzku zzku2) throws IOException {
        this.zzd(n, 2);
        this.zzc(zzku2);
    }

    public final void zzf(int n, zzih zzih2) throws IOException {
        zzgf zzgf2 = this.zzhc();
        zzgf2.zzb(6, zzih2);
        zzgf2.flush();
        this.zzaae = this.zzot.position();
    }

    public final void zzb(int n, byte[] byArray) throws IOException {
        this.zzd(3, 2);
        byte[] byArray2 = byArray;
        zzkm zzkm2 = this;
        zzkm2.zzbt(byArray2.length);
        zzkm2.zzk(byArray2);
    }

    private static int zzb(CharSequence charSequence) {
        int n;
        int n2;
        int n3 = n2 = charSequence.length();
        for (n = 0; n < n2 && charSequence.charAt(n) < '\u0080'; ++n) {
        }
        while (n < n2) {
            char c = charSequence.charAt(n);
            if (c < '\u0800') {
                n3 += 127 - c >>> 31;
            } else {
                int n4 = n;
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = 0;
                for (int i = n4; i < n5; ++i) {
                    char c2 = charSequence2.charAt(i);
                    if (c2 < '\u0800') {
                        n6 += 127 - c2 >>> 31;
                        continue;
                    }
                    n6 += 2;
                    if ('\ud800' > c2 || c2 > '\udfff') continue;
                    if (Character.codePointAt(charSequence2, i) < 65536) {
                        int n7 = i;
                        throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n7).toString());
                    }
                    ++i;
                }
                n3 += n6;
                break;
            }
            ++n;
        }
        if (n3 < n2) {
            long l = (long)n3 + 0x100000000L;
            throw new IllegalArgumentException(new StringBuilder(54).append("UTF-8 length does not fit in int: ").append(l).toString());
        }
        return n3;
    }

    private static void zze(CharSequence charSequence, ByteBuffer byteBuffer) {
        if (byteBuffer.isReadOnly()) {
            throw new ReadOnlyBufferException();
        }
        if (byteBuffer.hasArray()) {
            try {
                int n;
                char c;
                int n2;
                int n3 = byteBuffer.remaining();
                int n4 = byteBuffer.arrayOffset() + byteBuffer.position();
                byte[] byArray = byteBuffer.array();
                CharSequence charSequence2 = charSequence;
                int n5 = charSequence2.length();
                int n6 = n4 + n3;
                for (n2 = 0; n2 < n5 && n2 + n4 < n6 && (c = charSequence2.charAt(n2)) < '\u0080'; ++n2) {
                    byArray[n4 + n2] = (byte)c;
                }
                if (n2 == n5) {
                    n = n4 + n5;
                } else {
                    int n7 = n4 + n2;
                    while (n2 < n5) {
                        int n8;
                        char c2;
                        c = charSequence2.charAt(n2);
                        if (c < '\u0080' && n7 < n6) {
                            byArray[n7++] = (byte)c;
                        } else if (c < '\u0800' && n7 <= n6 - 2) {
                            byArray[n7++] = (byte)(0x3C0 | c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if ((c < '\ud800' || '\udfff' < c) && n7 <= n6 - 3) {
                            byArray[n7++] = (byte)(0x1E0 | c >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & c);
                        } else if (n7 <= n6 - 4) {
                            if (n2 + 1 == charSequence2.length() || !Character.isSurrogatePair(c, c2 = charSequence2.charAt(++n2))) {
                                n8 = n2 - 1;
                                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n8).toString());
                            }
                            n8 = Character.toCodePoint(c, c2);
                            byArray[n7++] = (byte)(0xF0 | n8 >>> 18);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 12);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8 >>> 6);
                            byArray[n7++] = (byte)(0x80 | 0x3F & n8);
                        } else {
                            c2 = c;
                            n8 = n7;
                            throw new ArrayIndexOutOfBoundsException(new StringBuilder(37).append("Failed writing ").append(c2).append(" at index ").append(n8).toString());
                        }
                        ++n2;
                    }
                    n = n7;
                }
                int n9 = n;
                byteBuffer.position(n9 - byteBuffer.arrayOffset());
                return;
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                BufferOverflowException bufferOverflowException = new BufferOverflowException();
                bufferOverflowException.initCause(arrayIndexOutOfBoundsException);
                throw bufferOverflowException;
            }
        }
        ByteBuffer byteBuffer2 = byteBuffer;
        CharSequence charSequence3 = charSequence;
        int n = charSequence3.length();
        for (int i = 0; i < n; ++i) {
            int n10;
            char c;
            char c3 = charSequence3.charAt(i);
            if (c3 < '\u0080') {
                byteBuffer2.put((byte)c3);
                continue;
            }
            if (c3 < '\u0800') {
                byteBuffer2.put((byte)(0x3C0 | c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (c3 < '\ud800' || '\udfff' < c3) {
                byteBuffer2.put((byte)(0x1E0 | c3 >>> 12));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3 >>> 6));
                byteBuffer2.put((byte)(0x80 | 0x3F & c3));
                continue;
            }
            if (i + 1 == charSequence3.length() || !Character.isSurrogatePair(c3, c = charSequence3.charAt(++i))) {
                n10 = i - 1;
                throw new IllegalArgumentException(new StringBuilder(39).append("Unpaired surrogate at index ").append(n10).toString());
            }
            n10 = Character.toCodePoint(c3, c);
            byteBuffer2.put((byte)(0xF0 | n10 >>> 18));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 12));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10 >>> 6));
            byteBuffer2.put((byte)(0x80 | 0x3F & n10));
        }
    }

    public final void zzc(zzku zzku2) throws IOException {
        zzku zzku3 = zzku2;
        if (zzku3.zzaap < 0) {
            zzku3.zzdg();
        }
        this.zzbt(zzku3.zzaap);
        zzku2.zzb(this);
    }

    public static int zze(int n, long l) {
        long l2;
        return zzkm.zzas(n) + (((l2 = l) & 0xFFFFFFFFFFFFFF80L) == 0L ? 1 : ((l2 & 0xFFFFFFFFFFFFC000L) == 0L ? 2 : ((l2 & 0xFFFFFFFFFFE00000L) == 0L ? 3 : ((l2 & 0xFFFFFFFFF0000000L) == 0L ? 4 : ((l2 & 0xFFFFFFF800000000L) == 0L ? 5 : ((l2 & 0xFFFFFC0000000000L) == 0L ? 6 : ((l2 & 0xFFFE000000000000L) == 0L ? 7 : ((l2 & 0xFF00000000000000L) == 0L ? 8 : ((l2 & Long.MIN_VALUE) == 0L ? 9 : 10)))))))));
    }

    public static int zzi(int n, int n2) {
        return zzkm.zzas(n) + zzkm.zzat(n2);
    }

    public static int zzc(int n, String string) {
        return zzkm.zzas(n) + zzkm.zzl(string);
    }

    public static int zzc(int n, zzku zzku2) {
        int n2 = zzku2.zzdg();
        return zzkm.zzas(n) + (zzkm.zzba(n2) + n2);
    }

    public static int zzat(int n) {
        if (n >= 0) {
            return zzkm.zzba(n);
        }
        return 10;
    }

    public static int zzl(String string) {
        int n = zzkm.zzb(string);
        return zzkm.zzba(n) + n;
    }

    public static int zzj(byte[] byArray) {
        return zzkm.zzba(byArray.length) + byArray.length;
    }

    public final void zzhd() {
        if (this.zzot.remaining() != 0) {
            throw new IllegalStateException(String.format("Did not write as much data as expected, %s bytes remaining.", this.zzot.remaining()));
        }
    }

    public final void zzc(byte by) throws IOException {
        if (!this.zzot.hasRemaining()) {
            throw new zzkn(this.zzot.position(), this.zzot.limit());
        }
        this.zzot.put(by);
    }

    private final void zzbs(int n) throws IOException {
        byte by = (byte)n;
        zzkm zzkm2 = this;
        if (!zzkm2.zzot.hasRemaining()) {
            throw new zzkn(zzkm2.zzot.position(), zzkm2.zzot.limit());
        }
        zzkm2.zzot.put(by);
    }

    public final void zzk(byte[] byArray) throws IOException {
        int n = byArray.length;
        byte[] byArray2 = byArray;
        zzkm zzkm2 = this;
        if (zzkm2.zzot.remaining() >= n) {
            zzkm2.zzot.put(byArray2, 0, n);
            return;
        }
        throw new zzkn(zzkm2.zzot.position(), zzkm2.zzot.limit());
    }

    public final void zzd(int n, int n2) throws IOException {
        int n3 = n2;
        this.zzbt(n << 3 | n3);
    }

    public static int zzas(int n) {
        return zzkm.zzba(n << 3);
    }

    public final void zzbt(int n) throws IOException {
        while (true) {
            if ((n & 0xFFFFFF80) == 0) {
                this.zzbs(n);
                return;
            }
            this.zzbs(n & 0x7F | 0x80);
            n >>>= 7;
        }
    }

    public static int zzba(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return 1;
        }
        if ((n & 0xFFFFC000) == 0) {
            return 2;
        }
        if ((n & 0xFFE00000) == 0) {
            return 3;
        }
        if ((n & 0xF0000000) == 0) {
            return 4;
        }
        return 5;
    }

    private final void zzq(long l) throws IOException {
        while (true) {
            if ((l & 0xFFFFFFFFFFFFFF80L) == 0L) {
                this.zzbs((int)l);
                return;
            }
            this.zzbs((int)l & 0x7F | 0x80);
            l >>>= 7;
        }
    }
}

