/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.internal;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.internal.zzag;
import com.google.android.gms.location.places.internal.zzah;
import com.google.android.gms.location.places.internal.zzam;
import com.google.android.gms.location.places.internal.zzh;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

@SafeParcelable.Reserved(value={1000, 2, 3, 12, 13, 16, 18})
@SafeParcelable.Class(creator="PlaceEntityCreator")
public final class PlaceEntity
extends AbstractSafeParcelable
implements ReflectedParcelable,
Place {
    public static final Parcelable.Creator<PlaceEntity> CREATOR = new zzag();
    @SafeParcelable.Field(id=1, getter="getId")
    private final String zzgf;
    @SafeParcelable.Field(id=4, getter="getLatLng")
    private final LatLng latLng;
    @SafeParcelable.Field(id=5, getter="getLevelNumber")
    private final float zzgg;
    @SafeParcelable.Field(id=6, getter="getViewport")
    private final LatLngBounds zzgh;
    @SafeParcelable.Field(id=7, getter="getTimeZoneId")
    private final String zzgi;
    @SafeParcelable.Field(id=8, getter="getWebsiteUri")
    private final Uri zzds;
    @SafeParcelable.Field(id=9, getter="isPermanentlyClosed")
    private final boolean zzgj;
    @SafeParcelable.Field(id=10, getter="getRating")
    private final float zzgk;
    @SafeParcelable.Field(id=11, getter="getPriceLevel")
    private final int zzgl;
    @SafeParcelable.Field(id=20, getter="getPlaceTypes")
    private final List<Integer> zzdq;
    @SafeParcelable.Field(id=19, getter="getName")
    private final String name;
    @SafeParcelable.Field(id=14, getter="getAddress")
    private final String zzdp;
    @SafeParcelable.Field(id=15, getter="getPhoneNumber")
    private final String zzdr;
    @SafeParcelable.Field(id=17, getter="getAttributionsList")
    private final List<String> zzgm;
    @SafeParcelable.Field(id=21, getter="getPlaceOpeningHours")
    private final zzam zzgn;
    @SafeParcelable.Field(id=22, getter="getExtendedDetails")
    private final zzah zzgo;
    @SafeParcelable.Field(id=23, getter="getAdrAddress")
    private final String zzgp;
    private Locale locale;

    @SafeParcelable.Constructor
    PlaceEntity(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=20) List<Integer> list, @SafeParcelable.Param(id=19) String string2, @SafeParcelable.Param(id=14) String string3, @SafeParcelable.Param(id=15) String string4, @SafeParcelable.Param(id=17) List<String> list2, @SafeParcelable.Param(id=4) LatLng latLng, @SafeParcelable.Param(id=5) float f, @SafeParcelable.Param(id=6) LatLngBounds latLngBounds, @SafeParcelable.Param(id=7) String string5, @SafeParcelable.Param(id=8) Uri uri, @SafeParcelable.Param(id=9) boolean bl, @SafeParcelable.Param(id=10) float f2, @SafeParcelable.Param(id=11) int n, @SafeParcelable.Param(id=21) zzam zzam2, @SafeParcelable.Param(id=22) zzah zzah2, @SafeParcelable.Param(id=23) String string6) {
        this.zzgf = string;
        this.zzdq = Collections.unmodifiableList(list);
        this.name = string2;
        this.zzdp = string3;
        this.zzdr = string4;
        this.zzgm = list2 != null ? list2 : Collections.emptyList();
        this.latLng = latLng;
        this.zzgg = f;
        this.zzgh = latLngBounds;
        this.zzgi = string5 != null ? string5 : "UTC";
        this.zzds = uri;
        this.zzgj = bl;
        this.zzgk = f2;
        this.zzgl = n;
        this.locale = null;
        this.zzgn = zzam2;
        this.zzgo = zzah2;
        this.zzgp = string6;
    }

    @Override
    @VisibleForTesting
    public final String getId() {
        return this.zzgf;
    }

    @Override
    public final List<Integer> getPlaceTypes() {
        return this.zzdq;
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    @VisibleForTesting
    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final LatLng getLatLng() {
        return this.latLng;
    }

    @Override
    public final LatLngBounds getViewport() {
        return this.zzgh;
    }

    @Override
    public final Uri getWebsiteUri() {
        return this.zzds;
    }

    @Override
    @Nullable
    public final CharSequence getAttributions() {
        return zzh.zzg(this.zzgm);
    }

    @Override
    public final float getRating() {
        return this.zzgk;
    }

    @Override
    public final int getPriceLevel() {
        return this.zzgl;
    }

    @SuppressLint(value={"DefaultLocale"})
    public final String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.zzgf).add("placeTypes", this.zzdq).add("locale", (Object)this.locale).add("name", (Object)this.name).add("address", (Object)this.zzdp).add("phoneNumber", (Object)this.zzdr).add("latlng", (Object)this.latLng).add("viewport", (Object)this.zzgh).add("websiteUri", (Object)this.zzds).add("isPermanentlyClosed", (Object)this.zzgj).add("priceLevel", (Object)this.zzgl).toString();
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzgf, this.locale});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlaceEntity)) {
            return false;
        }
        PlaceEntity placeEntity = (PlaceEntity)object;
        return this.zzgf.equals(placeEntity.zzgf) && Objects.equal((Object)this.locale, (Object)placeEntity.locale);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlaceEntity placeEntity = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)placeEntity.getId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)placeEntity.getLatLng(), (int)n, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)5, (float)placeEntity.zzgg);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)6, (Parcelable)placeEntity.getViewport(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)placeEntity.zzgi, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)placeEntity.getWebsiteUri(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)placeEntity.zzgj);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)10, (float)placeEntity.getRating());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)11, (int)placeEntity.getPriceLevel());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)14, (String)((String)placeEntity.getAddress()), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)15, (String)((String)placeEntity.getPhoneNumber()), (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)17, placeEntity.zzgm, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)19, (String)((String)placeEntity.getName()), (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)20, placeEntity.getPlaceTypes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)21, (Parcelable)placeEntity.zzgn, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)22, (Parcelable)placeEntity.zzgo, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)23, (String)placeEntity.zzgp, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean isDataValid() {
        return true;
    }

    @Override
    public final /* synthetic */ CharSequence getPhoneNumber() {
        return this.zzdr;
    }

    @Override
    public final /* synthetic */ CharSequence getName() {
        return this.name;
    }

    @Override
    public final /* synthetic */ CharSequence getAddress() {
        return this.zzdp;
    }

    public static final class zzb {
        private String zzgf;
        private String name;
        private LatLng latLng;
        private float zzgg;
        private LatLngBounds zzgh;
        private Uri zzds;
        private boolean zzgj;
        private float zzgk = -1.0f;
        private int zzgl = -1;
        private List<Integer> zzgq;
        private String zzdp;
        private String zzdr;
        private List<String> zzgm;
        private zzam zzgn;
        private zzah zzgr;
        private String zzgp;

        public final zzb zzc(String string) {
            this.zzgf = string;
            return this;
        }

        public final zzb zzd(String string) {
            this.name = string;
            return this;
        }

        public final zzb zzb(LatLng latLng) {
            this.latLng = latLng;
            return this;
        }

        public final zzb zzb(float f) {
            this.zzgg = f;
            return this;
        }

        public final zzb zzb(LatLngBounds latLngBounds) {
            this.zzgh = latLngBounds;
            return this;
        }

        public final zzb zzb(Uri uri) {
            this.zzds = uri;
            return this;
        }

        public final zzb zzb(boolean bl) {
            this.zzgj = bl;
            return this;
        }

        public final zzb zzc(float f) {
            this.zzgk = f;
            return this;
        }

        public final zzb zzf(int n) {
            this.zzgl = n;
            return this;
        }

        public final zzb zzc(List<Integer> list) {
            this.zzgq = list;
            return this;
        }

        public final zzb zze(String string) {
            this.zzdp = string;
            return this;
        }

        public final zzb zzf(String string) {
            this.zzdr = string;
            return this;
        }

        public final zzb zzd(List<String> list) {
            this.zzgm = list;
            return this;
        }

        public final zzb zzb(zzam zzam2) {
            this.zzgn = zzam2;
            return this;
        }

        public final zzb zzb(zzah zzah2) {
            this.zzgr = zzah2;
            return this;
        }

        public final zzb zzg(String string) {
            this.zzgp = string;
            return this;
        }

        public final PlaceEntity zzag() {
            return new PlaceEntity(this.zzgf, this.zzgq, this.name, this.zzdp, this.zzdr, this.zzgm, this.latLng, this.zzgg, this.zzgh, null, this.zzds, this.zzgj, this.zzgk, this.zzgl, this.zzgn, this.zzgr, this.zzgp);
        }
    }
}

