/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.places.zzdo;
import com.google.android.gms.location.places.AutocompletePredictionBuffer;
import com.google.android.gms.location.places.PlaceBuffer;
import com.google.android.gms.location.places.PlaceLikelihoodBuffer;
import com.google.android.gms.location.places.internal.zzz;

public class zzm
extends zzz {
    private static final String TAG = zzm.class.getSimpleName();
    private final zze zzex;
    private final zzb zzey;
    private final zzf zzez;
    private final zzg zzfa;
    private final zzd zzfb;

    public zzm(zze zze2) {
        this.zzex = zze2;
        this.zzey = null;
        this.zzez = null;
        this.zzfa = null;
        this.zzfb = null;
    }

    public zzm(zzb zzb2) {
        this.zzex = null;
        this.zzey = zzb2;
        this.zzez = null;
        this.zzfa = null;
        this.zzfb = null;
    }

    public zzm(zzg zzg2) {
        this.zzex = null;
        this.zzey = null;
        this.zzez = null;
        this.zzfa = zzg2;
        this.zzfb = null;
    }

    public zzm(zzd zzd2) {
        this.zzex = null;
        this.zzey = null;
        this.zzez = null;
        this.zzfa = null;
        this.zzfb = zzd2;
    }

    @Override
    public final void zzb(DataHolder dataHolder) throws RemoteException {
        Preconditions.checkState((this.zzex != null ? 1 : 0) != 0, (Object)"placeEstimator cannot be null");
        if (dataHolder == null) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"onPlaceEstimated received null DataHolder", (Throwable)new Throwable());
            }
            this.zzex.setFailedResult(Status.RESULT_INTERNAL_ERROR);
            return;
        }
        Bundle bundle = dataHolder.getMetadata();
        int n = bundle == null ? 100 : PlaceLikelihoodBuffer.zzb(bundle);
        PlaceLikelihoodBuffer placeLikelihoodBuffer = new PlaceLikelihoodBuffer(dataHolder, n);
        this.zzex.setResult(placeLikelihoodBuffer);
    }

    @Override
    public final void zzc(DataHolder dataHolder) throws RemoteException {
        if (dataHolder == null) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"onAutocompletePrediction received null DataHolder", (Throwable)new Throwable());
            }
            this.zzey.setFailedResult(Status.RESULT_INTERNAL_ERROR);
            return;
        }
        this.zzey.setResult(new AutocompletePredictionBuffer(dataHolder));
    }

    @Override
    public final void zzd(DataHolder dataHolder) throws RemoteException {
        if (dataHolder == null) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"onPlaceUserDataFetched received null DataHolder", (Throwable)new Throwable());
            }
            null.setFailedResult(Status.RESULT_INTERNAL_ERROR);
            return;
        }
        null.setResult((Result)new zzdo(dataHolder));
    }

    @Override
    public final void zze(Status status) throws RemoteException {
        this.zzfa.setResult((Result)status);
    }

    @Override
    public final void zze(DataHolder dataHolder) throws RemoteException {
        PlaceBuffer placeBuffer = new PlaceBuffer(dataHolder);
        this.zzfb.setResult(placeBuffer);
    }

    public static abstract class zzg<A extends Api.Client>
    extends zzc<Status, A> {
        public zzg(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            return status;
        }
    }

    public static abstract class zzb<A extends Api.Client>
    extends zzc<AutocompletePredictionBuffer, A> {
        public zzb(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new AutocompletePredictionBuffer(DataHolder.empty((int)status2.getStatusCode()));
        }
    }

    @Deprecated
    public static abstract class zzf<A extends Api.Client>
    extends zzc<zzdo, A> {
    }

    public static abstract class zzd<A extends Api.Client>
    extends zzc<PlaceBuffer, A> {
        public zzd(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new PlaceBuffer(DataHolder.empty((int)status2.getStatusCode()));
        }
    }

    public static abstract class zze<A extends Api.Client>
    extends zzc<PlaceLikelihoodBuffer, A> {
        public zze(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new PlaceLikelihoodBuffer(DataHolder.empty((int)status2.getStatusCode()), 100);
        }
    }

    public static abstract class zzc<R extends Result, A extends Api.Client>
    extends BaseImplementation.ApiMethodImpl<R, A> {
        public zzc(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }
    }
}

