/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.places;

import com.google.android.gms.internal.places.zzbd;
import com.google.android.gms.internal.places.zzbh;
import com.google.android.gms.internal.places.zzbi;
import com.google.android.gms.internal.places.zzcw;
import com.google.android.gms.internal.places.zzq;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzbe
extends zzq<Integer>
implements zzbi,
zzcw,
RandomAccess {
    private static final zzbe zzjc = new zzbe(new int[0], 0);
    private int[] zzjd;
    private int size;

    public static zzbe zzbo() {
        return zzjc;
    }

    zzbe() {
        this(new int[10], 0);
    }

    private zzbe(int[] nArray, int n) {
        this.zzjd = nArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzac();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzjd, n2, this.zzjd, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzbe)) {
            return super.equals(object);
        }
        zzbe zzbe2 = (zzbe)object;
        if (this.size != zzbe2.size) {
            return false;
        }
        int[] nArray = zzbe2.zzjd;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzjd[i] == nArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + this.zzjd[i];
        }
        return n;
    }

    public final int getInt(int n) {
        this.zzf(n);
        return this.zzjd[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzac(int n) {
        this.zzp(this.size, n);
    }

    private final void zzp(int n, int n2) {
        this.zzac();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
        if (this.size < this.zzjd.length) {
            System.arraycopy(this.zzjd, n, this.zzjd, n + 1, this.size - n);
        } else {
            int[] nArray = new int[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzjd, 0, nArray, 0, n);
            System.arraycopy(this.zzjd, n, nArray, n + 1, this.size - n);
            this.zzjd = nArray;
        }
        this.zzjd[n] = n2;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Integer> collection) {
        this.zzac();
        zzbd.checkNotNull(collection);
        if (!(collection instanceof zzbe)) {
            return super.addAll(collection);
        }
        zzbe zzbe2 = (zzbe)collection;
        if (zzbe2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzbe2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzbe2.size;
        if (n > this.zzjd.length) {
            this.zzjd = Arrays.copyOf(this.zzjd, n);
        }
        System.arraycopy(zzbe2.zzjd, 0, this.zzjd, this.size, zzbe2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzac();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzjd[i])) continue;
            System.arraycopy(this.zzjd, i + 1, this.zzjd, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzg(n));
        }
    }

    private final String zzg(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Integer n2 = (Integer)object;
        int n3 = n2;
        zzbe zzbe2 = this;
        zzbe2.zzac();
        zzbe2.zzf(n);
        int n4 = zzbe2.zzjd[n];
        zzbe2.zzjd[n] = n3;
        return n4;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzbe zzbe2 = this;
        zzbe2.zzac();
        zzbe2.zzf(n);
        int n2 = zzbe2.zzjd[n];
        if (n < zzbe2.size - 1) {
            System.arraycopy(zzbe2.zzjd, n + 1, zzbe2.zzjd, n, zzbe2.size - n - 1);
        }
        --zzbe2.size;
        ++zzbe2.modCount;
        return n2;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Integer n2 = (Integer)object;
        this.zzp(n, n2);
    }

    @Override
    public final /* synthetic */ zzbh zzh(int n) {
        int n2 = n;
        zzbe zzbe2 = this;
        if (n2 < zzbe2.size) {
            throw new IllegalArgumentException();
        }
        return new zzbe(Arrays.copyOf(zzbe2.zzjd, n2), zzbe2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getInt(n);
    }

    static {
        zzjc.zzab();
    }
}

