/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.internal;

import android.annotation.SuppressLint;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;
import com.google.android.gms.common.internal.Objects;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.common.internal.safeparcel.AbstractSafeParcelable;
import com.google.android.gms.common.internal.safeparcel.SafeParcelWriter;
import com.google.android.gms.common.internal.safeparcel.SafeParcelable;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.location.places.Place;
import com.google.android.gms.location.places.internal.zzag;
import com.google.android.gms.location.places.internal.zzai;
import com.google.android.gms.location.places.internal.zzal;
import com.google.android.gms.location.places.internal.zzi;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.Nullable;

@SafeParcelable.Reserved(value={1000, 2, 3, 12, 13, 16, 18})
@SafeParcelable.Class(creator="PlaceEntityCreator")
public final class PlaceEntity
extends AbstractSafeParcelable
implements ReflectedParcelable,
Place {
    public static final Parcelable.Creator<PlaceEntity> CREATOR = new zzag();
    @SafeParcelable.Field(id=1, getter="getId")
    private final String zzbw;
    @SafeParcelable.Field(id=4, getter="getLatLng")
    private final LatLng latLng;
    @SafeParcelable.Field(id=5, getter="getLevelNumber")
    private final float zzbx;
    @SafeParcelable.Field(id=6, getter="getViewport")
    private final LatLngBounds zzby;
    @SafeParcelable.Field(id=7, getter="getTimeZoneId")
    private final String zzbz;
    @SafeParcelable.Field(id=8, getter="getWebsiteUri")
    private final Uri zzi;
    @SafeParcelable.Field(id=9, getter="isPermanentlyClosed")
    private final boolean zzca;
    @SafeParcelable.Field(id=10, getter="getRating")
    private final float zzcb;
    @SafeParcelable.Field(id=11, getter="getPriceLevel")
    private final int zzcc;
    @SafeParcelable.Field(id=20, getter="getPlaceTypes")
    private final List<Integer> zzg;
    @SafeParcelable.Field(id=19, getter="getName")
    private final String name;
    @SafeParcelable.Field(id=14, getter="getAddress")
    private final String zzf;
    @SafeParcelable.Field(id=15, getter="getPhoneNumber")
    private final String zzh;
    @SafeParcelable.Field(id=17, getter="getAttributionsList")
    private final List<String> zzcd;
    @SafeParcelable.Field(id=21, getter="getPlaceOpeningHours")
    private final zzal zzce;
    @SafeParcelable.Field(id=22, getter="getExtendedDetails")
    private final zzai zzcf;
    @SafeParcelable.Field(id=23, getter="getAdrAddress")
    private final String zzcg;
    private Locale locale;

    @SafeParcelable.Constructor
    PlaceEntity(@SafeParcelable.Param(id=1) String string, @SafeParcelable.Param(id=20) List<Integer> list, @SafeParcelable.Param(id=19) String string2, @SafeParcelable.Param(id=14) String string3, @SafeParcelable.Param(id=15) String string4, @SafeParcelable.Param(id=17) List<String> list2, @SafeParcelable.Param(id=4) LatLng latLng, @SafeParcelable.Param(id=5) float f, @SafeParcelable.Param(id=6) LatLngBounds latLngBounds, @SafeParcelable.Param(id=7) String string5, @SafeParcelable.Param(id=8) Uri uri, @SafeParcelable.Param(id=9) boolean bl, @SafeParcelable.Param(id=10) float f2, @SafeParcelable.Param(id=11) int n, @SafeParcelable.Param(id=21) zzal zzal2, @SafeParcelable.Param(id=22) zzai zzai2, @SafeParcelable.Param(id=23) String string6) {
        this.zzbw = string;
        this.zzg = Collections.unmodifiableList(list);
        this.name = string2;
        this.zzf = string3;
        this.zzh = string4;
        this.zzcd = list2 != null ? list2 : Collections.emptyList();
        this.latLng = latLng;
        this.zzbx = f;
        this.zzby = latLngBounds;
        this.zzbz = string5 != null ? string5 : "UTC";
        this.zzi = uri;
        this.zzca = bl;
        this.zzcb = f2;
        this.zzcc = n;
        this.locale = null;
        this.zzce = zzal2;
        this.zzcf = zzai2;
        this.zzcg = string6;
    }

    @Override
    @VisibleForTesting
    public final String getId() {
        return this.zzbw;
    }

    @Override
    public final List<Integer> getPlaceTypes() {
        return this.zzg;
    }

    @Override
    public final Locale getLocale() {
        return this.locale;
    }

    @VisibleForTesting
    public final void setLocale(Locale locale) {
        this.locale = locale;
    }

    @Override
    public final LatLng getLatLng() {
        return this.latLng;
    }

    @Override
    public final LatLngBounds getViewport() {
        return this.zzby;
    }

    @Override
    public final Uri getWebsiteUri() {
        return this.zzi;
    }

    @Override
    @Nullable
    public final CharSequence getAttributions() {
        return com.google.android.gms.location.places.internal.zzi.zzc(this.zzcd);
    }

    @Override
    public final float getRating() {
        return this.zzcb;
    }

    @Override
    public final int getPriceLevel() {
        return this.zzcc;
    }

    @SuppressLint(value={"DefaultLocale"})
    public final String toString() {
        return Objects.toStringHelper((Object)this).add("id", (Object)this.zzbw).add("placeTypes", this.zzg).add("locale", (Object)this.locale).add("name", (Object)this.name).add("address", (Object)this.zzf).add("phoneNumber", (Object)this.zzh).add("latlng", (Object)this.latLng).add("viewport", (Object)this.zzby).add("websiteUri", (Object)this.zzi).add("isPermanentlyClosed", (Object)this.zzca).add("priceLevel", (Object)this.zzcc).toString();
    }

    public final int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.zzbw, this.locale});
    }

    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof PlaceEntity)) {
            return false;
        }
        PlaceEntity placeEntity = (PlaceEntity)object;
        return this.zzbw.equals(placeEntity.zzbw) && Objects.equal((Object)this.locale, (Object)placeEntity.locale);
    }

    public final void writeToParcel(Parcel parcel, int n) {
        Parcel parcel2 = parcel;
        PlaceEntity placeEntity = this;
        int n2 = SafeParcelWriter.beginObjectHeader((Parcel)parcel2);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)1, (String)placeEntity.getId(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)4, (Parcelable)placeEntity.getLatLng(), (int)n, (boolean)false);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)5, (float)placeEntity.zzbx);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)6, (Parcelable)placeEntity.getViewport(), (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)7, (String)placeEntity.zzbz, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)8, (Parcelable)placeEntity.getWebsiteUri(), (int)n, (boolean)false);
        SafeParcelWriter.writeBoolean((Parcel)parcel2, (int)9, (boolean)placeEntity.zzca);
        SafeParcelWriter.writeFloat((Parcel)parcel2, (int)10, (float)placeEntity.getRating());
        SafeParcelWriter.writeInt((Parcel)parcel2, (int)11, (int)placeEntity.getPriceLevel());
        SafeParcelWriter.writeString((Parcel)parcel2, (int)14, (String)((String)placeEntity.getAddress()), (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)15, (String)((String)placeEntity.getPhoneNumber()), (boolean)false);
        SafeParcelWriter.writeStringList((Parcel)parcel2, (int)17, placeEntity.zzcd, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)19, (String)((String)placeEntity.getName()), (boolean)false);
        SafeParcelWriter.writeIntegerList((Parcel)parcel2, (int)20, placeEntity.getPlaceTypes(), (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)21, (Parcelable)placeEntity.zzce, (int)n, (boolean)false);
        SafeParcelWriter.writeParcelable((Parcel)parcel2, (int)22, (Parcelable)placeEntity.zzcf, (int)n, (boolean)false);
        SafeParcelWriter.writeString((Parcel)parcel2, (int)23, (String)placeEntity.zzcg, (boolean)false);
        SafeParcelWriter.finishObjectHeader((Parcel)parcel2, (int)n2);
    }

    public final boolean isDataValid() {
        return true;
    }

    @Override
    public final /* synthetic */ CharSequence getPhoneNumber() {
        return this.zzh;
    }

    @Override
    public final /* synthetic */ CharSequence getName() {
        return this.name;
    }

    @Override
    public final /* synthetic */ CharSequence getAddress() {
        return this.zzf;
    }

    public static final class zzb {
        private String zzbw;
        private String name;
        private LatLng latLng;
        private float zzbx;
        private LatLngBounds zzby;
        private Uri zzi;
        private boolean zzca;
        private float zzcb = -1.0f;
        private int zzcc = -1;
        private List<Integer> zzch;
        private String zzf;
        private String zzh;
        private List<String> zzcd;
        private zzal zzce;
        private zzai zzci;
        private String zzcg;

        public final zzb zzb(String string) {
            this.zzbw = string;
            return this;
        }

        public final zzb zzc(String string) {
            this.name = string;
            return this;
        }

        public final zzb zzb(LatLng latLng) {
            this.latLng = latLng;
            return this;
        }

        public final zzb zzb(float f) {
            this.zzbx = f;
            return this;
        }

        public final zzb zzb(LatLngBounds latLngBounds) {
            this.zzby = latLngBounds;
            return this;
        }

        public final zzb zzb(Uri uri) {
            this.zzi = uri;
            return this;
        }

        public final zzb zzb(boolean bl) {
            this.zzca = bl;
            return this;
        }

        public final zzb zzc(float f) {
            this.zzcb = f;
            return this;
        }

        public final zzb zzc(int n) {
            this.zzcc = n;
            return this;
        }

        public final zzb zzc(List<Integer> list) {
            this.zzch = list;
            return this;
        }

        public final zzb zzd(String string) {
            this.zzf = string;
            return this;
        }

        public final zzb zze(String string) {
            this.zzh = string;
            return this;
        }

        public final zzb zzd(List<String> list) {
            this.zzcd = list;
            return this;
        }

        public final zzb zzb(zzal zzal2) {
            this.zzce = zzal2;
            return this;
        }

        public final zzb zzb(zzai zzai2) {
            this.zzci = zzai2;
            return this;
        }

        public final zzb zzf(String string) {
            this.zzcg = string;
            return this;
        }

        public final PlaceEntity zzj() {
            return new PlaceEntity(this.zzbw, this.zzch, this.name, this.zzf, this.zzh, this.zzcd, this.latLng, this.zzbx, this.zzby, null, this.zzi, this.zzca, this.zzcb, this.zzcc, this.zzce, this.zzci, this.zzcg);
        }
    }
}

