/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places.internal;

import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.location.places.AddPlaceRequest;
import com.google.android.gms.location.places.AutocompleteFilter;
import com.google.android.gms.location.places.AutocompletePredictionBuffer;
import com.google.android.gms.location.places.GeoDataApi;
import com.google.android.gms.location.places.PlaceBuffer;
import com.google.android.gms.location.places.PlacePhotoMetadata;
import com.google.android.gms.location.places.PlacePhotoMetadataResult;
import com.google.android.gms.location.places.PlacePhotoResult;
import com.google.android.gms.location.places.Places;
import com.google.android.gms.location.places.internal.zzap;
import com.google.android.gms.location.places.internal.zzj;
import com.google.android.gms.location.places.internal.zzk;
import com.google.android.gms.location.places.internal.zzl;
import com.google.android.gms.location.places.internal.zzm;
import com.google.android.gms.location.places.internal.zzn;
import com.google.android.gms.location.places.internal.zzo;
import com.google.android.gms.maps.model.LatLngBounds;

public final class zzh
implements GeoDataApi {
    @Override
    public final PendingResult<PlaceBuffer> addPlace(@NonNull GoogleApiClient googleApiClient, @NonNull AddPlaceRequest addPlaceRequest) {
        Preconditions.checkNotNull((Object)((Object)addPlaceRequest), (Object)"userAddedPlace == null");
        return googleApiClient.execute((BaseImplementation.ApiMethodImpl)new zzk(this, Places.GEO_DATA_API, googleApiClient, addPlaceRequest));
    }

    @Override
    public final PendingResult<PlaceBuffer> getPlaceById(@NonNull GoogleApiClient googleApiClient, String ... stringArray) {
        Preconditions.checkArgument((stringArray != null ? 1 : 0) != 0, (Object)"placeIds == null");
        Preconditions.checkArgument((stringArray.length > 0 ? 1 : 0) != 0, (Object)"placeIds is empty");
        String[] stringArray2 = stringArray;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string = stringArray2[i];
            Preconditions.checkArgument((string != null ? 1 : 0) != 0, (Object)"placeId == null");
            Preconditions.checkArgument((!string.isEmpty() ? 1 : 0) != 0, (Object)"placeId is empty");
        }
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzl(this, Places.GEO_DATA_API, googleApiClient, stringArray));
    }

    public final PendingResult<AutocompletePredictionBuffer> zzb(GoogleApiClient googleApiClient, @Nullable String string, @Nullable LatLngBounds latLngBounds, int n, @Nullable AutocompleteFilter autocompleteFilter) {
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzo(this, Places.GEO_DATA_API, googleApiClient, string, latLngBounds, n, autocompleteFilter));
    }

    @Override
    public final PendingResult<AutocompletePredictionBuffer> getAutocompletePredictions(@NonNull GoogleApiClient googleApiClient, @Nullable String string, @Nullable LatLngBounds latLngBounds, @Nullable AutocompleteFilter autocompleteFilter) {
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzn(this, Places.GEO_DATA_API, googleApiClient, string, latLngBounds, autocompleteFilter));
    }

    @Override
    public final PendingResult<PlacePhotoMetadataResult> getPlacePhotos(@NonNull GoogleApiClient googleApiClient, @NonNull String string) {
        Preconditions.checkNotNull((Object)string, (Object)"placeId == null");
        Preconditions.checkArgument((!string.isEmpty() ? 1 : 0) != 0, (Object)"placeId is empty");
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzj(this, Places.GEO_DATA_API, googleApiClient, string));
    }

    public final PendingResult<PlacePhotoResult> zzb(@NonNull GoogleApiClient googleApiClient, @NonNull PlacePhotoMetadata placePhotoMetadata, @IntRange(from=1L) int n, @IntRange(from=1L) int n2) {
        Preconditions.checkNotNull((Object)placePhotoMetadata, (Object)"photo == null");
        Preconditions.checkArgument((n > 0 ? 1 : 0) != 0, (Object)"width <= 0");
        Preconditions.checkArgument((n2 > 0 ? 1 : 0) != 0, (Object)"height <= 0");
        zzap zzap2 = (zzap)placePhotoMetadata.freeze();
        String string = zzap2.zzk();
        int n3 = zzap2.getIndex();
        Preconditions.checkNotNull((Object)string, (Object)"fifeUrl == null");
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)new zzm(this, Places.GEO_DATA_API, googleApiClient, string, n, n2, n3));
    }
}

