/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.location.places;

import android.os.Bundle;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.common.api.Api;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.internal.places.zzh;
import com.google.android.gms.location.places.AutocompletePredictionBuffer;
import com.google.android.gms.location.places.PlaceBuffer;
import com.google.android.gms.location.places.PlaceLikelihoodBuffer;
import com.google.android.gms.location.places.internal.zzaa;

public class zzm
extends zzaa {
    private static final String TAG = zzm.class.getSimpleName();
    private final zzd zzal;
    private final zzc zzam;
    private final zzg zzan;
    private final zzf zzao;
    private final zze zzap;

    public zzm(zzd zzd2) {
        this.zzal = zzd2;
        this.zzam = null;
        this.zzan = null;
        this.zzao = null;
        this.zzap = null;
    }

    public zzm(zzc zzc2) {
        this.zzal = null;
        this.zzam = zzc2;
        this.zzan = null;
        this.zzao = null;
        this.zzap = null;
    }

    public zzm(zzf zzf2) {
        this.zzal = null;
        this.zzam = null;
        this.zzan = null;
        this.zzao = zzf2;
        this.zzap = null;
    }

    public zzm(zze zze2) {
        this.zzal = null;
        this.zzam = null;
        this.zzan = null;
        this.zzao = null;
        this.zzap = zze2;
    }

    @Override
    public final void zzb(DataHolder dataHolder) throws RemoteException {
        Preconditions.checkState((this.zzal != null ? 1 : 0) != 0, (Object)"placeEstimator cannot be null");
        if (dataHolder == null) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"onPlaceEstimated received null DataHolder", (Throwable)new Throwable());
            }
            this.zzal.setFailedResult(Status.RESULT_INTERNAL_ERROR);
            return;
        }
        Bundle bundle = dataHolder.getMetadata();
        int n = bundle == null ? 100 : PlaceLikelihoodBuffer.zzb(bundle);
        PlaceLikelihoodBuffer placeLikelihoodBuffer = new PlaceLikelihoodBuffer(dataHolder, n);
        this.zzal.setResult(placeLikelihoodBuffer);
    }

    @Override
    public final void zzc(DataHolder dataHolder) throws RemoteException {
        if (dataHolder == null) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"onAutocompletePrediction received null DataHolder", (Throwable)new Throwable());
            }
            this.zzam.setFailedResult(Status.RESULT_INTERNAL_ERROR);
            return;
        }
        this.zzam.setResult(new AutocompletePredictionBuffer(dataHolder));
    }

    @Override
    public final void zzd(DataHolder dataHolder) throws RemoteException {
        if (dataHolder == null) {
            if (Log.isLoggable((String)TAG, (int)6)) {
                Log.e((String)TAG, (String)"onPlaceUserDataFetched received null DataHolder", (Throwable)new Throwable());
            }
            null.setFailedResult(Status.RESULT_INTERNAL_ERROR);
            return;
        }
        null.setResult((Result)new zzh(dataHolder));
    }

    @Override
    public final void zzb(Status status) throws RemoteException {
        this.zzao.setResult((Result)status);
    }

    @Override
    public final void zze(DataHolder dataHolder) throws RemoteException {
        PlaceBuffer placeBuffer = new PlaceBuffer(dataHolder);
        this.zzap.setResult(placeBuffer);
    }

    public static abstract class zzf<A extends Api.Client>
    extends zzb<Status, A> {
        public zzf(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            return status;
        }
    }

    public static abstract class zzc<A extends Api.Client>
    extends zzb<AutocompletePredictionBuffer, A> {
        public zzc(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new AutocompletePredictionBuffer(DataHolder.empty((int)status2.getStatusCode()));
        }
    }

    @Deprecated
    public static abstract class zzg<A extends Api.Client>
    extends zzb<zzh, A> {
    }

    public static abstract class zze<A extends Api.Client>
    extends zzb<PlaceBuffer, A> {
        public zze(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new PlaceBuffer(DataHolder.empty((int)status2.getStatusCode()));
        }
    }

    public static abstract class zzd<A extends Api.Client>
    extends zzb<PlaceLikelihoodBuffer, A> {
        public zzd(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }

        protected /* synthetic */ Result createFailedResult(Status status) {
            Status status2 = status;
            return new PlaceLikelihoodBuffer(DataHolder.empty((int)status2.getStatusCode()), 100);
        }
    }

    public static abstract class zzb<R extends Result, A extends Api.Client>
    extends BaseImplementation.ApiMethodImpl<R, A> {
        public zzb(Api api, GoogleApiClient googleApiClient) {
            super(api, googleApiClient);
        }
    }
}

