/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.common.internal.zzap;
import com.google.android.gms.plus.internal.zzg;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View zzbBL;
    private int mSize;
    private int zzbBM;
    private String zzE;
    private int zzbBN;
    private OnPlusOneClickListener zzbBO;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mSize = PlusOneButton.getSize(context, attributeSet);
        this.zzbBM = PlusOneButton.getAnnotation(context, attributeSet);
        this.zzbBN = -1;
        this.zzaO(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attributeSet) {
        String string = zzap.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"size", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "SMALL".equalsIgnoreCase(string) ? 0 : ("MEDIUM".equalsIgnoreCase(string) ? 1 : ("TALL".equalsIgnoreCase(string) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attributeSet) {
        String string = zzap.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"annotation", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "INLINE".equalsIgnoreCase(string) ? 2 : ("NONE".equalsIgnoreCase(string) ? 0 : 1);
    }

    private void zzaO(Context context) {
        if (this.zzbBL != null) {
            this.removeView(this.zzbBL);
        }
        this.zzbBL = zzg.zza(context, this.mSize, this.zzbBM, this.zzE, this.zzbBN);
        this.setOnPlusOneClickListener(this.zzbBO);
        this.addView(this.zzbBL);
    }

    public void initialize(String string, int n) {
        zzac.zza((boolean)(this.getContext() instanceof Activity), (Object)"To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.zzE = string;
        this.zzbBN = n;
        this.zzaO(this.getContext());
    }

    public void initialize(String string, OnPlusOneClickListener onPlusOneClickListener) {
        this.zzE = string;
        this.zzbBN = 0;
        this.zzaO(this.getContext());
        this.setOnPlusOneClickListener(onPlusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
        this.zzbBO = onPlusOneClickListener;
        this.zzbBL.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(onPlusOneClickListener));
    }

    public void setAnnotation(int n) {
        this.zzbBM = n;
        this.zzaO(this.getContext());
    }

    public void setSize(int n) {
        this.mSize = n;
        this.zzaO(this.getContext());
    }

    protected void onMeasure(int n, int n2) {
        View view = this.zzbBL;
        this.measureChild(view, n, n2);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.zzbBL.layout(0, 0, n3 - n, n4 - n2);
    }

    public void plusOneClick() {
        this.zzbBL.performClick();
    }

    public void setIntent(Intent intent) {
        this.zzbBL.setTag((Object)intent);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener zzbBP;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
            this.zzbBP = onPlusOneClickListener;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.zzbBL.getTag();
            if (this.zzbBP != null) {
                this.zzbBP.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.zzbBN);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

