/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzbr;
import com.google.android.gms.common.internal.zzce;
import com.google.android.gms.plus.internal.zzm;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View mContentView;
    private int mSize;
    private int zzbAx;
    private String zzD;
    private int zzbAy;
    private OnPlusOneClickListener zzbAz;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mSize = PlusOneButton.getSize(context, attributeSet);
        this.zzbAx = PlusOneButton.getAnnotation(context, attributeSet);
        this.zzbAy = -1;
        this.zzbk(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attributeSet) {
        String string = zzce.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"size", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        if ("SMALL".equalsIgnoreCase(string)) {
            return 0;
        }
        if ("MEDIUM".equalsIgnoreCase(string)) {
            return 1;
        }
        if ("TALL".equalsIgnoreCase(string)) {
            return 2;
        }
        return 3;
    }

    protected static int getAnnotation(Context context, AttributeSet attributeSet) {
        String string = zzce.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"annotation", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        if ("INLINE".equalsIgnoreCase(string)) {
            return 2;
        }
        if ("NONE".equalsIgnoreCase(string)) {
            return 0;
        }
        return 1;
    }

    private final void zzbk(Context context) {
        if (this.mContentView != null) {
            this.removeView(this.mContentView);
        }
        this.mContentView = zzm.zza(context, this.mSize, this.zzbAx, this.zzD, this.zzbAy);
        this.setOnPlusOneClickListener(this.zzbAz);
        this.addView(this.mContentView);
    }

    public final void initialize(String string, int n) {
        zzbr.zza((boolean)(this.getContext() instanceof Activity), (Object)"To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.zzD = string;
        this.zzbAy = n;
        this.zzbk(this.getContext());
    }

    public final void initialize(String string, OnPlusOneClickListener onPlusOneClickListener) {
        this.zzD = string;
        this.zzbAy = 0;
        this.zzbk(this.getContext());
        this.setOnPlusOneClickListener(onPlusOneClickListener);
    }

    public final void setOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
        this.zzbAz = onPlusOneClickListener;
        this.mContentView.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(this, onPlusOneClickListener));
    }

    public final void setAnnotation(int n) {
        this.zzbAx = n;
        this.zzbk(this.getContext());
    }

    public final void setSize(int n) {
        this.mSize = n;
        this.zzbk(this.getContext());
    }

    protected final void onMeasure(int n, int n2) {
        View view = this.mContentView;
        this.measureChild(view, n, n2);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected final void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mContentView.layout(0, 0, n3 - n, n4 - n2);
    }

    public final void plusOneClick() {
        this.mContentView.performClick();
    }

    public final void setIntent(Intent intent) {
        this.mContentView.setTag((Object)intent);
    }

    public class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener zzbAA;
        private /* synthetic */ PlusOneButton zzbAB;

        public DefaultOnPlusOneClickListener(PlusOneButton plusOneButton, OnPlusOneClickListener onPlusOneClickListener) {
            this.zzbAB = plusOneButton;
            this.zzbAA = onPlusOneClickListener;
        }

        public void onClick(View view) {
            Intent intent = (Intent)this.zzbAB.mContentView.getTag();
            if (this.zzbAA != null) {
                this.zzbAA.onPlusOneClick(intent);
                return;
            }
            this.onPlusOneClick(intent);
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = this.zzbAB.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, this.zzbAB.zzbAy);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

