/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus.internal;

import android.content.Context;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.ClientSettings;
import com.google.android.gms.common.internal.GmsClient;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.internal.plus.zzr;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.Plus;
import com.google.android.gms.plus.internal.zza;
import com.google.android.gms.plus.internal.zzf;
import com.google.android.gms.plus.internal.zzg;
import com.google.android.gms.plus.internal.zzj;
import com.google.android.gms.plus.internal.zzk;
import com.google.android.gms.plus.internal.zzn;
import com.google.android.gms.plus.model.people.Person;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public final class zzh
extends GmsClient<zzf> {
    private Person zzr;
    private final zzn zzs;

    public zzh(Context context, Looper looper, ClientSettings clientSettings, zzn zzn2, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 2, clientSettings, connectionCallbacks, onConnectionFailedListener);
        this.zzs = zzn2;
    }

    public final boolean requiresSignIn() {
        Set set = this.getClientSettings().getApplicableScopes(Plus.API);
        if (set == null || set.isEmpty()) {
            return false;
        }
        return set.size() != 1 || !set.contains(new Scope("plus_one_placeholder_scope"));
    }

    @VisibleForTesting
    public final String getAccountName() {
        this.checkConnected();
        try {
            return ((zzf)this.getService()).getAccountName();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    @VisibleForTesting
    public final ICancelToken zza(BaseImplementation.ResultHolder<People.LoadPeopleResult> resultHolder, int n, String string) {
        this.checkConnected();
        zzj zzj2 = new zzj(resultHolder);
        try {
            return ((zzf)this.getService()).zza(zzj2, 1, n, -1, string);
        }
        catch (RemoteException remoteException) {
            ((zza)zzj2).zza(DataHolder.empty((int)8), null);
            return null;
        }
    }

    public final void zza(BaseImplementation.ResultHolder<People.LoadPeopleResult> resultHolder) {
        this.checkConnected();
        zzj zzj2 = new zzj(resultHolder);
        try {
            ((zzf)this.getService()).zza(zzj2, 2, 1, -1, null);
            return;
        }
        catch (RemoteException remoteException) {
            ((zza)zzj2).zza(DataHolder.empty((int)8), null);
            return;
        }
    }

    public final void zza(BaseImplementation.ResultHolder<People.LoadPeopleResult> resultHolder, String[] stringArray) {
        this.zza(resultHolder, Arrays.asList(stringArray));
    }

    @VisibleForTesting
    public final void zza(BaseImplementation.ResultHolder<People.LoadPeopleResult> resultHolder, Collection<String> collection) {
        this.checkConnected();
        zzj zzj2 = new zzj(resultHolder);
        try {
            ((zzf)this.getService()).zza(zzj2, new ArrayList<String>(collection));
            return;
        }
        catch (RemoteException remoteException) {
            ((zza)zzj2).zza(DataHolder.empty((int)8), null);
            return;
        }
    }

    @VisibleForTesting
    public final Person zzb() {
        this.checkConnected();
        return this.zzr;
    }

    @VisibleForTesting
    public final void zza() {
        this.checkConnected();
        try {
            this.zzr = null;
            ((zzf)this.getService()).zza();
            return;
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    @VisibleForTesting
    public final void zzb(BaseImplementation.ResultHolder<Status> resultHolder) {
        this.checkConnected();
        this.zza();
        zzk zzk2 = new zzk(resultHolder);
        try {
            ((zzf)this.getService()).zza(zzk2);
            return;
        }
        catch (RemoteException remoteException) {
            ((zza)zzk2).zza(8, (Bundle)null);
            return;
        }
    }

    protected final String getServiceDescriptor() {
        return "com.google.android.gms.plus.internal.IPlusService";
    }

    protected final String getStartServiceAction() {
        return "com.google.android.gms.plus.service.START";
    }

    protected final Bundle getGetServiceRequestExtraArgs() {
        Bundle bundle = this.zzs.zze();
        bundle.putStringArray("request_visible_actions", this.zzs.zzc());
        bundle.putString("auth_package", this.zzs.zzd());
        return bundle;
    }

    protected final void onPostInitHandler(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null && bundle.containsKey("loaded_person")) {
            this.zzr = com.google.android.gms.internal.plus.zzr.zza(bundle.getByteArray("loaded_person"));
        }
        super.onPostInitHandler(n, iBinder, bundle, n2);
    }

    public final int getMinApkVersion() {
        return 12451000;
    }

    protected final /* synthetic */ IInterface createServiceInterface(IBinder iBinder) {
        IBinder iBinder2 = iBinder;
        if (iBinder2 == null) {
            return null;
        }
        IInterface iInterface = iBinder2.queryLocalInterface("com.google.android.gms.plus.internal.IPlusService");
        if (iInterface instanceof zzf) {
            return (zzf)iInterface;
        }
        return new zzg(iBinder2);
    }
}

