/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.plus.Moments;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.Plus;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.model.moments.MomentEntity;
import com.google.android.gms.plus.internal.model.people.PersonEntity;
import com.google.android.gms.plus.internal.zzd;
import com.google.android.gms.plus.model.moments.Moment;
import com.google.android.gms.plus.model.moments.MomentBuffer;
import com.google.android.gms.plus.model.people.Person;
import com.google.android.gms.plus.model.people.PersonBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class zze
extends zzi<com.google.android.gms.plus.internal.zzd> {
    private Person zzayX;
    private final PlusSession zzayY;

    public ICancelToken zzr(zza.zzb<People.LoadPeopleResult> zzb2, String string) {
        return this.zza(zzb2, 0, string);
    }

    public zze(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, PlusSession plusSession, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 2, connectionCallbacks, onConnectionFailedListener, zze2);
        this.zzayY = plusSession;
    }

    public boolean zzjM() {
        return zze.zze(this.zzlU().zzb(Plus.API));
    }

    public static boolean zze(Set<Scope> set) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        return set.size() != 1 || !set.contains(new Scope("plus_one_placeholder_scope"));
    }

    public String getAccountName() {
        this.zzlW();
        try {
            return ((com.google.android.gms.plus.internal.zzd)this.zzlX()).getAccountName();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(zza.zzb<Status> zzb2, Moment moment) {
        this.zzlW();
        zzc zzc2 = zzb2 != null ? new zzc(zzb2) : null;
        try {
            SafeParcelResponse safeParcelResponse = SafeParcelResponse.zza((FastJsonResponse)((MomentEntity)moment));
            ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zza((com.google.android.gms.plus.internal.zzb)zzc2, safeParcelResponse);
        }
        catch (RemoteException remoteException) {
            if (zzc2 == null) {
                throw new IllegalStateException(remoteException);
            }
            Status status = new Status(8, null, null);
            zzc2.zzaI(status);
        }
    }

    public void zza(zza.zzb<Moments.LoadMomentsResult> zzb2, int n, String string, Uri uri, String string2, String string3) {
        this.zzlW();
        zzd zzd2 = zzb2 != null ? new zzd(zzb2) : null;
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zza(zzd2, n, string, uri, string2, string3);
        }
        catch (RemoteException remoteException) {
            zzd2.zza(DataHolder.zzaE((int)8), null, null);
        }
    }

    public void zzi(zza.zzb<Moments.LoadMomentsResult> zzb2) {
        this.zza(zzb2, 20, null, null, null, "me");
    }

    public void zzdp(String string) {
        this.zzlW();
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zzdp(string);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public ICancelToken zza(zza.zzb<People.LoadPeopleResult> zzb2, int n, String string) {
        this.zzlW();
        zze zze2 = new zze(zzb2);
        try {
            return ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zza(zze2, 1, n, -1, string);
        }
        catch (RemoteException remoteException) {
            zze2.zza(DataHolder.zzaE((int)8), null);
            return null;
        }
    }

    public void zzj(zza.zzb<People.LoadPeopleResult> zzb2) {
        this.zzlW();
        zze zze2 = new zze(zzb2);
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zza(zze2, 2, 1, -1, null);
        }
        catch (RemoteException remoteException) {
            zze2.zza(DataHolder.zzaE((int)8), null);
        }
    }

    public void zzd(zza.zzb<People.LoadPeopleResult> zzb2, String[] stringArray) {
        this.zza(zzb2, Arrays.asList(stringArray));
    }

    public void zza(zza.zzb<People.LoadPeopleResult> zzb2, Collection<String> collection) {
        this.zzlW();
        zze zze2 = new zze(zzb2);
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zza((com.google.android.gms.plus.internal.zzb)zze2, new ArrayList<String>(collection));
        }
        catch (RemoteException remoteException) {
            zze2.zza(DataHolder.zzaE((int)8), null);
        }
    }

    public Person zzvy() {
        this.zzlW();
        return this.zzayX;
    }

    public void zzvv() {
        this.zzlW();
        try {
            this.zzayX = null;
            ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zzvv();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzk(zza.zzb<Status> zzb2) {
        this.zzlW();
        this.zzvv();
        zzf zzf2 = new zzf(zzb2);
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zzlX()).zzb(zzf2);
        }
        catch (RemoteException remoteException) {
            zzf2.zzj(8, null);
        }
    }

    protected com.google.android.gms.plus.internal.zzd zzcy(IBinder iBinder) {
        return zzd.zza.zzcx(iBinder);
    }

    protected String zzer() {
        return "com.google.android.gms.plus.internal.IPlusService";
    }

    protected String zzeq() {
        return "com.google.android.gms.plus.service.START";
    }

    protected Bundle zzka() {
        return this.zzvz();
    }

    protected Bundle zzlY() {
        return this.zzvz();
    }

    private Bundle zzvz() {
        Bundle bundle = this.zzayY.zzvK();
        bundle.putStringArray("request_visible_actions", this.zzayY.zzvD());
        bundle.putString("auth_package", this.zzayY.zzvF());
        return bundle;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle) {
        if (n == 0 && bundle != null && bundle.containsKey("loaded_person")) {
            this.zzayX = PersonEntity.zzl(bundle.getByteArray("loaded_person"));
        }
        super.zza(n, iBinder, bundle);
    }

    protected /* synthetic */ IInterface zzD(IBinder iBinder) {
        return this.zzcy(iBinder);
    }

    static final class zzf
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<Status> zzari;

        public zzf(zza.zzb<Status> zzb2) {
            this.zzari = zzb2;
        }

        @Override
        public void zzj(int n, Bundle bundle) {
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("pendingIntent");
            }
            Status status = new Status(n, null, pendingIntent);
            this.zzari.zzj((Object)status);
        }
    }

    static final class zzc
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<Status> zzari;

        public zzc(zza.zzb<Status> zzb2) {
            this.zzari = zzb2;
        }

        @Override
        public void zzaI(Status status) {
            this.zzari.zzj((Object)status);
        }
    }

    static final class zze
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<People.LoadPeopleResult> zzari;

        public zze(zza.zzb<People.LoadPeopleResult> zzb2) {
            this.zzari = zzb2;
        }

        @Override
        public void zza(DataHolder dataHolder, String string) {
            Status status;
            PendingIntent pendingIntent = null;
            if (dataHolder.zzlm() != null) {
                pendingIntent = (PendingIntent)dataHolder.zzlm().getParcelable("pendingIntent");
            }
            if (!(status = new Status(dataHolder.getStatusCode(), null, pendingIntent)).isSuccess() && dataHolder != null) {
                if (!dataHolder.isClosed()) {
                    dataHolder.close();
                }
                dataHolder = null;
            }
            this.zzari.zzj((Object)new zzb(status, dataHolder, string));
        }
    }

    static final class zzd
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<Moments.LoadMomentsResult> zzari;

        public zzd(zza.zzb<Moments.LoadMomentsResult> zzb2) {
            this.zzari = zzb2;
        }

        @Override
        public void zza(DataHolder dataHolder, String string, String string2) {
            Status status;
            PendingIntent pendingIntent = null;
            if (dataHolder.zzlm() != null) {
                pendingIntent = (PendingIntent)dataHolder.zzlm().getParcelable("pendingIntent");
            }
            if (!(status = new Status(dataHolder.getStatusCode(), null, pendingIntent)).isSuccess() && dataHolder != null) {
                if (!dataHolder.isClosed()) {
                    dataHolder.close();
                }
                dataHolder = null;
            }
            this.zzari.zzj((Object)new zza(status, dataHolder, string, string2));
        }
    }

    static final class zzb
    implements People.LoadPeopleResult {
        private final Status zzKr;
        private final String zzayZ;
        private final PersonBuffer zzazc;

        public zzb(Status status, DataHolder dataHolder, String string) {
            this.zzKr = status;
            this.zzayZ = string;
            this.zzazc = dataHolder != null ? new PersonBuffer(dataHolder) : null;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public PersonBuffer getPersonBuffer() {
            return this.zzazc;
        }

        @Override
        public String getNextPageToken() {
            return this.zzayZ;
        }

        public void release() {
            if (this.zzazc != null) {
                this.zzazc.release();
            }
        }
    }

    static final class zza
    implements Moments.LoadMomentsResult {
        private final Status zzKr;
        private final String zzayZ;
        private final String zzaza;
        private final MomentBuffer zzazb;

        public zza(Status status, DataHolder dataHolder, String string, String string2) {
            this.zzKr = status;
            this.zzayZ = string;
            this.zzaza = string2;
            this.zzazb = dataHolder != null ? new MomentBuffer(dataHolder) : null;
        }

        public Status getStatus() {
            return this.zzKr;
        }

        @Override
        public MomentBuffer getMomentBuffer() {
            return this.zzazb;
        }

        @Override
        public String getNextPageToken() {
            return this.zzayZ;
        }

        @Override
        public String getUpdated() {
            return this.zzaza;
        }

        public void release() {
            if (this.zzazb != null) {
                this.zzazb.release();
            }
        }
    }
}

