/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzab;
import com.google.android.gms.common.internal.zzu;
import com.google.android.gms.plus.internal.zzg;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View zzaHd;
    private int mSize;
    private int zzaHe;
    private String zzF;
    private int zzaHf;
    private OnPlusOneClickListener zzaHg;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSize = PlusOneButton.getSize(context, attrs);
        this.zzaHe = PlusOneButton.getAnnotation(context, attrs);
        this.zzaHf = -1;
        this.zzaf(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attrs) {
        String string = zzab.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"size", (Context)context, (AttributeSet)attrs, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "SMALL".equalsIgnoreCase(string) ? 0 : ("MEDIUM".equalsIgnoreCase(string) ? 1 : ("TALL".equalsIgnoreCase(string) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attrs) {
        String string = zzab.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"annotation", (Context)context, (AttributeSet)attrs, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "INLINE".equalsIgnoreCase(string) ? 2 : ("NONE".equalsIgnoreCase(string) ? 0 : 1);
    }

    private void zzaf(Context context) {
        if (this.zzaHd != null) {
            this.removeView(this.zzaHd);
        }
        this.zzaHd = zzg.zza(context, this.mSize, this.zzaHe, this.zzF, this.zzaHf);
        this.setOnPlusOneClickListener(this.zzaHg);
        this.addView(this.zzaHd);
    }

    public void initialize(String url, int activityRequestCode) {
        zzu.zza((boolean)(this.getContext() instanceof Activity), (Object)"To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.zzF = url;
        this.zzaHf = activityRequestCode;
        this.zzaf(this.getContext());
    }

    public void initialize(String url, OnPlusOneClickListener plusOneClickListener) {
        this.zzF = url;
        this.zzaHf = 0;
        this.zzaf(this.getContext());
        this.setOnPlusOneClickListener(plusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener listener) {
        this.zzaHg = listener;
        this.zzaHd.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(listener));
    }

    public void setAnnotation(int annotation) {
        this.zzaHe = annotation;
        this.zzaf(this.getContext());
    }

    public void setSize(int size) {
        this.mSize = size;
        this.zzaf(this.getContext());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        View view = this.zzaHd;
        this.measureChild(view, widthMeasureSpec, heightMeasureSpec);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        this.zzaHd.layout(0, 0, right - left, bottom - top);
    }

    public void plusOneClick() {
        this.zzaHd.performClick();
    }

    public void setIntent(Intent intent) {
        this.zzaHd.setTag((Object)intent);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener zzaHh;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener proxy) {
            this.zzaHh = proxy;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.zzaHd.getTag();
            if (this.zzaHh != null) {
                this.zzaHh.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.zzaHf);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

