/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus.internal;

import android.app.PendingIntent;
import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Looper;
import android.os.RemoteException;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.Scope;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.api.zza;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.common.internal.ICancelToken;
import com.google.android.gms.common.internal.zzi;
import com.google.android.gms.common.server.response.FastJsonResponse;
import com.google.android.gms.common.server.response.SafeParcelResponse;
import com.google.android.gms.plus.Moments;
import com.google.android.gms.plus.People;
import com.google.android.gms.plus.Plus;
import com.google.android.gms.plus.internal.PlusSession;
import com.google.android.gms.plus.internal.model.moments.MomentEntity;
import com.google.android.gms.plus.internal.model.people.PersonEntity;
import com.google.android.gms.plus.internal.zzd;
import com.google.android.gms.plus.model.moments.Moment;
import com.google.android.gms.plus.model.moments.MomentBuffer;
import com.google.android.gms.plus.model.people.Person;
import com.google.android.gms.plus.model.people.PersonBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public class zze
extends zzi<com.google.android.gms.plus.internal.zzd> {
    private Person zzaHl;
    private final PlusSession zzaHm;

    public ICancelToken zzq(zza.zzb<People.LoadPeopleResult> zzb2, String string) {
        return this.zza(zzb2, 0, string);
    }

    public zze(Context context, Looper looper, com.google.android.gms.common.internal.zze zze2, PlusSession plusSession, GoogleApiClient.ConnectionCallbacks connectionCallbacks, GoogleApiClient.OnConnectionFailedListener onConnectionFailedListener) {
        super(context, looper, 2, connectionCallbacks, onConnectionFailedListener, zze2);
        this.zzaHm = plusSession;
    }

    public boolean requiresSignIn() {
        return zze.zze(this.zznK().zzb(Plus.API));
    }

    public static boolean zze(Set<Scope> set) {
        if (set == null || set.isEmpty()) {
            return false;
        }
        return set.size() != 1 || !set.contains(new Scope("plus_one_placeholder_scope"));
    }

    public String getAccountName() {
        this.zznL();
        try {
            return ((com.google.android.gms.plus.internal.zzd)this.zznM()).getAccountName();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zza(zza.zzb<Status> zzb2, Moment moment) {
        this.zznL();
        zzc zzc2 = zzb2 != null ? new zzc(zzb2) : null;
        try {
            SafeParcelResponse safeParcelResponse = SafeParcelResponse.zza((FastJsonResponse)((MomentEntity)moment));
            ((com.google.android.gms.plus.internal.zzd)this.zznM()).zza((com.google.android.gms.plus.internal.zzb)zzc2, safeParcelResponse);
        }
        catch (RemoteException remoteException) {
            if (zzc2 == null) {
                throw new IllegalStateException(remoteException);
            }
            Status status = new Status(8, null, null);
            zzc2.zzaO(status);
        }
    }

    public void zza(zza.zzb<Moments.LoadMomentsResult> zzb2, int n, String string, Uri uri, String string2, String string3) {
        this.zznL();
        zzd zzd2 = zzb2 != null ? new zzd(zzb2) : null;
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zznM()).zza(zzd2, n, string, uri, string2, string3);
        }
        catch (RemoteException remoteException) {
            zzd2.zza(DataHolder.zzbi((int)8), null, null);
        }
    }

    public void zzi(zza.zzb<Moments.LoadMomentsResult> zzb2) {
        this.zza(zzb2, 20, null, null, null, "me");
    }

    public void zzdX(String string) {
        this.zznL();
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zznM()).zzdX(string);
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public ICancelToken zza(zza.zzb<People.LoadPeopleResult> zzb2, int n, String string) {
        this.zznL();
        zze zze2 = new zze(zzb2);
        try {
            return ((com.google.android.gms.plus.internal.zzd)this.zznM()).zza(zze2, 1, n, -1, string);
        }
        catch (RemoteException remoteException) {
            zze2.zza(DataHolder.zzbi((int)8), null);
            return null;
        }
    }

    public void zzj(zza.zzb<People.LoadPeopleResult> zzb2) {
        this.zznL();
        zze zze2 = new zze(zzb2);
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zznM()).zza(zze2, 2, 1, -1, null);
        }
        catch (RemoteException remoteException) {
            zze2.zza(DataHolder.zzbi((int)8), null);
        }
    }

    public void zzd(zza.zzb<People.LoadPeopleResult> zzb2, String[] stringArray) {
        this.zza(zzb2, Arrays.asList(stringArray));
    }

    public void zza(zza.zzb<People.LoadPeopleResult> zzb2, Collection<String> collection) {
        this.zznL();
        zze zze2 = new zze(zzb2);
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zznM()).zza((com.google.android.gms.plus.internal.zzb)zze2, new ArrayList<String>(collection));
        }
        catch (RemoteException remoteException) {
            zze2.zza(DataHolder.zzbi((int)8), null);
        }
    }

    public Person zzxu() {
        this.zznL();
        return this.zzaHl;
    }

    public void zzxr() {
        this.zznL();
        try {
            this.zzaHl = null;
            ((com.google.android.gms.plus.internal.zzd)this.zznM()).zzxr();
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException(remoteException);
        }
    }

    public void zzk(zza.zzb<Status> zzb2) {
        this.zznL();
        this.zzxr();
        zzf zzf2 = new zzf(zzb2);
        try {
            ((com.google.android.gms.plus.internal.zzd)this.zznM()).zzb(zzf2);
        }
        catch (RemoteException remoteException) {
            zzf2.zzi(8, null);
        }
    }

    protected com.google.android.gms.plus.internal.zzd zzdu(IBinder iBinder) {
        return zzd.zza.zzdt(iBinder);
    }

    protected String getServiceDescriptor() {
        return "com.google.android.gms.plus.internal.IPlusService";
    }

    protected String getStartServiceAction() {
        return "com.google.android.gms.plus.service.START";
    }

    protected Bundle zzkR() {
        return this.zzkS();
    }

    protected Bundle zznN() {
        return this.zzkS();
    }

    private Bundle zzkS() {
        Bundle bundle = this.zzaHm.zzxE();
        bundle.putStringArray("request_visible_actions", this.zzaHm.zzxy());
        bundle.putString("auth_package", this.zzaHm.zzxA());
        return bundle;
    }

    protected void zza(int n, IBinder iBinder, Bundle bundle, int n2) {
        if (n == 0 && bundle != null && bundle.containsKey("loaded_person")) {
            this.zzaHl = PersonEntity.zzp(bundle.getByteArray("loaded_person"));
        }
        super.zza(n, iBinder, bundle, n2);
    }

    protected /* synthetic */ IInterface zzT(IBinder iBinder) {
        return this.zzdu(iBinder);
    }

    static final class zzf
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<Status> zzayZ;

        public zzf(zza.zzb<Status> zzb2) {
            this.zzayZ = zzb2;
        }

        @Override
        public void zzi(int n, Bundle bundle) {
            PendingIntent pendingIntent = null;
            if (bundle != null) {
                pendingIntent = (PendingIntent)bundle.getParcelable("pendingIntent");
            }
            Status status = new Status(n, null, pendingIntent);
            this.zzayZ.zzm((Object)status);
        }
    }

    static final class zzc
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<Status> zzayZ;

        public zzc(zza.zzb<Status> zzb2) {
            this.zzayZ = zzb2;
        }

        @Override
        public void zzaO(Status status) {
            this.zzayZ.zzm((Object)status);
        }
    }

    static final class zze
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<People.LoadPeopleResult> zzayZ;

        public zze(zza.zzb<People.LoadPeopleResult> zzb2) {
            this.zzayZ = zzb2;
        }

        @Override
        public void zza(DataHolder dataHolder, String string) {
            Status status;
            PendingIntent pendingIntent = null;
            if (dataHolder.zznb() != null) {
                pendingIntent = (PendingIntent)dataHolder.zznb().getParcelable("pendingIntent");
            }
            if (!(status = new Status(dataHolder.getStatusCode(), null, pendingIntent)).isSuccess() && dataHolder != null) {
                if (!dataHolder.isClosed()) {
                    dataHolder.close();
                }
                dataHolder = null;
            }
            this.zzayZ.zzm((Object)new zzb(status, dataHolder, string));
        }
    }

    static final class zzd
    extends com.google.android.gms.plus.internal.zza {
        private final zza.zzb<Moments.LoadMomentsResult> zzayZ;

        public zzd(zza.zzb<Moments.LoadMomentsResult> zzb2) {
            this.zzayZ = zzb2;
        }

        @Override
        public void zza(DataHolder dataHolder, String string, String string2) {
            Status status;
            PendingIntent pendingIntent = null;
            if (dataHolder.zznb() != null) {
                pendingIntent = (PendingIntent)dataHolder.zznb().getParcelable("pendingIntent");
            }
            if (!(status = new Status(dataHolder.getStatusCode(), null, pendingIntent)).isSuccess() && dataHolder != null) {
                if (!dataHolder.isClosed()) {
                    dataHolder.close();
                }
                dataHolder = null;
            }
            this.zzayZ.zzm((Object)new zza(status, dataHolder, string, string2));
        }
    }

    static final class zzb
    implements People.LoadPeopleResult {
        private final Status zzOt;
        private final String zzaHn;
        private final PersonBuffer zzaHq;

        public zzb(Status status, DataHolder dataHolder, String string) {
            this.zzOt = status;
            this.zzaHn = string;
            this.zzaHq = dataHolder != null ? new PersonBuffer(dataHolder) : null;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public PersonBuffer getPersonBuffer() {
            return this.zzaHq;
        }

        @Override
        public String getNextPageToken() {
            return this.zzaHn;
        }

        public void release() {
            if (this.zzaHq != null) {
                this.zzaHq.release();
            }
        }
    }

    static final class zza
    implements Moments.LoadMomentsResult {
        private final Status zzOt;
        private final String zzaHn;
        private final String zzaHo;
        private final MomentBuffer zzaHp;

        public zza(Status status, DataHolder dataHolder, String string, String string2) {
            this.zzOt = status;
            this.zzaHn = string;
            this.zzaHo = string2;
            this.zzaHp = dataHolder != null ? new MomentBuffer(dataHolder) : null;
        }

        public Status getStatus() {
            return this.zzOt;
        }

        @Override
        public MomentBuffer getMomentBuffer() {
            return this.zzaHp;
        }

        @Override
        public String getNextPageToken() {
            return this.zzaHn;
        }

        @Override
        public String getUpdated() {
            return this.zzaHo;
        }

        public void release() {
            if (this.zzaHp != null) {
                this.zzaHp.release();
            }
        }
    }
}

