/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.plus;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.AttributeSet;
import android.view.View;
import android.widget.FrameLayout;
import com.google.android.gms.common.internal.zzaa;
import com.google.android.gms.common.internal.zzaj;
import com.google.android.gms.plus.internal.zzg;

public final class PlusOneButton
extends FrameLayout {
    public static final int SIZE_SMALL = 0;
    public static final int SIZE_MEDIUM = 1;
    public static final int SIZE_TALL = 2;
    public static final int SIZE_STANDARD = 3;
    public static final int ANNOTATION_NONE = 0;
    public static final int ANNOTATION_BUBBLE = 1;
    public static final int ANNOTATION_INLINE = 2;
    public static final int DEFAULT_ACTIVITY_REQUEST_CODE = -1;
    private View zzblo;
    private int mSize;
    private int zzblp;
    private String zzE;
    private int zzblq;
    private OnPlusOneClickListener zzblr;

    public PlusOneButton(Context context) {
        this(context, null);
    }

    public PlusOneButton(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.mSize = PlusOneButton.getSize(context, attributeSet);
        this.zzblp = PlusOneButton.getAnnotation(context, attributeSet);
        this.zzblq = -1;
        this.zzar(this.getContext());
        if (this.isInEditMode()) {
            return;
        }
    }

    protected static int getSize(Context context, AttributeSet attributeSet) {
        String string = zzaj.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"size", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "SMALL".equalsIgnoreCase(string) ? 0 : ("MEDIUM".equalsIgnoreCase(string) ? 1 : ("TALL".equalsIgnoreCase(string) ? 2 : 3));
    }

    protected static int getAnnotation(Context context, AttributeSet attributeSet) {
        String string = zzaj.zza((String)"http://schemas.android.com/apk/lib/com.google.android.gms.plus", (String)"annotation", (Context)context, (AttributeSet)attributeSet, (boolean)true, (boolean)false, (String)"PlusOneButton");
        return "INLINE".equalsIgnoreCase(string) ? 2 : ("NONE".equalsIgnoreCase(string) ? 0 : 1);
    }

    private void zzar(Context context) {
        if (this.zzblo != null) {
            this.removeView(this.zzblo);
        }
        this.zzblo = zzg.zza(context, this.mSize, this.zzblp, this.zzE, this.zzblq);
        this.setOnPlusOneClickListener(this.zzblr);
        this.addView(this.zzblo);
    }

    public void initialize(String string, int n) {
        zzaa.zza((boolean)(this.getContext() instanceof Activity), (Object)"To use this method, the PlusOneButton must be placed in an Activity. Use initialize(String, OnPlusOneClickListener).");
        this.zzE = string;
        this.zzblq = n;
        this.zzar(this.getContext());
    }

    public void initialize(String string, OnPlusOneClickListener onPlusOneClickListener) {
        this.zzE = string;
        this.zzblq = 0;
        this.zzar(this.getContext());
        this.setOnPlusOneClickListener(onPlusOneClickListener);
    }

    public void setOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
        this.zzblr = onPlusOneClickListener;
        this.zzblo.setOnClickListener((View.OnClickListener)new DefaultOnPlusOneClickListener(onPlusOneClickListener));
    }

    public void setAnnotation(int n) {
        this.zzblp = n;
        this.zzar(this.getContext());
    }

    public void setSize(int n) {
        this.mSize = n;
        this.zzar(this.getContext());
    }

    protected void onMeasure(int n, int n2) {
        View view = this.zzblo;
        this.measureChild(view, n, n2);
        this.setMeasuredDimension(view.getMeasuredWidth(), view.getMeasuredHeight());
    }

    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.zzblo.layout(0, 0, n3 - n, n4 - n2);
    }

    public void plusOneClick() {
        this.zzblo.performClick();
    }

    public void setIntent(Intent intent) {
        this.zzblo.setTag((Object)intent);
    }

    protected class DefaultOnPlusOneClickListener
    implements View.OnClickListener,
    OnPlusOneClickListener {
        private final OnPlusOneClickListener zzbls;

        public DefaultOnPlusOneClickListener(OnPlusOneClickListener onPlusOneClickListener) {
            this.zzbls = onPlusOneClickListener;
        }

        public void onClick(View view) {
            Intent intent = (Intent)PlusOneButton.this.zzblo.getTag();
            if (this.zzbls != null) {
                this.zzbls.onPlusOneClick(intent);
            } else {
                this.onPlusOneClick(intent);
            }
        }

        @Override
        public void onPlusOneClick(Intent intent) {
            Context context = PlusOneButton.this.getContext();
            if (context instanceof Activity && intent != null) {
                ((Activity)context).startActivityForResult(intent, PlusOneButton.this.zzblq);
            }
        }
    }

    public static interface OnPlusOneClickListener {
        public void onPlusOneClick(Intent var1);
    }
}

