/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.recaptcha;

import android.os.LocaleList;
import android.text.TextUtils;
import android.webkit.URLUtil;
import com.google.android.gms.common.util.PlatformVersion;
import com.google.android.gms.internal.recaptcha.zzak;
import com.google.android.gms.internal.recaptcha.zzbe;
import com.google.android.gms.internal.recaptcha.zzbf;
import com.google.android.gms.internal.recaptcha.zzbg;
import com.google.android.gms.internal.recaptcha.zzf;
import com.google.android.gms.internal.recaptcha.zzl;
import com.google.android.gms.internal.recaptcha.zzm;
import com.google.android.gms.internal.recaptcha.zzop;
import com.google.android.gms.internal.recaptcha.zzow;
import com.google.android.gms.internal.recaptcha.zzqj;
import com.google.android.gms.internal.recaptcha.zzrg;
import com.google.android.gms.recaptcha.HttpStatusException;
import com.google.android.gms.recaptcha.RecaptchaNetworkException;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HttpsURLConnection;

public final class zzbh<ResponseT extends zzrg<ResponseT, ?>> {
    private final String zza;
    private final ExecutorService zzb;
    private final ResponseT zzc;

    public final <RequestT extends zzrg> Task<ResponseT> zza(RequestT RequestT) {
        TaskCompletionSource taskCompletionSource = new TaskCompletionSource();
        ExecutorService executorService = this.zzb;
        zzbe zzbe2 = new zzbe(this, taskCompletionSource, RequestT);
        executorService.execute(zzbe2);
        return taskCompletionSource.getTask();
    }

    public final <RequestT extends zzrg> zzop<ResponseT> zzb(RequestT RequestT) {
        ExecutorService executorService = this.zzb;
        executorService = zzow.zza(executorService);
        zzbf zzbf2 = new zzbf(this, RequestT);
        return executorService.zza(zzbf2);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private final <RequestT extends zzrg> ResponseT zzf(RequestT object) throws RecaptchaNetworkException, HttpStatusException {
        IOException iOException322222;
        block21: {
            Object object2;
            Object object3;
            Object object4;
            byte[] byArray;
            try {
                byArray = new byte[object.zzt()];
                object4 = zzqj.zzM(byArray);
                object.zzM((zzqj)object4);
                ((zzqj)object4).zzO();
            }
            catch (IOException iOException2) {
                object = object.getClass().getName();
                String string = String.valueOf(object);
                int n = string.length();
                StringBuilder stringBuilder = new StringBuilder(n + 72);
                stringBuilder.append("Serializing ");
                stringBuilder.append((String)object);
                stringBuilder.append(" to a byte array threw an IOException (should never happen).");
                RuntimeException runtimeException = new RuntimeException(stringBuilder.toString(), iOException2);
                throw runtimeException;
            }
            object4 = zzf.zza();
            object = new zzbg((zzbh)object2);
            HttpURLConnection httpURLConnection = ((zzm)object4).zzb((zzl)object, 21504, -1);
            httpURLConnection.setConnectTimeout(60000);
            httpURLConnection.setReadTimeout(60000);
            httpURLConnection.setRequestProperty("Content-type", "application/x-protobuffer");
            httpURLConnection.setRequestProperty("Content-Length", Integer.toString(byArray.length));
            String string = "Accept-Language";
            boolean bl = PlatformVersion.isAtLeastN();
            if (bl) {
                object3 = LocaleList.getDefault().toLanguageTags();
            } else {
                object3 = Locale.getDefault();
                boolean bl2 = PlatformVersion.isAtLeastLollipop();
                if (bl2) {
                    object3 = ((Locale)object3).toLanguageTag();
                } else {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(((Locale)object3).getLanguage());
                    boolean bl3 = TextUtils.isEmpty((CharSequence)stringBuilder.toString());
                    if (bl3) {
                        object3 = "und";
                    } else {
                        boolean bl4;
                        String string2 = ((Locale)object3).getCountry();
                        boolean bl5 = TextUtils.isEmpty((CharSequence)string2);
                        if (!bl5) {
                            stringBuilder.append("-");
                            stringBuilder.append(string2);
                        }
                        if (!(bl4 = TextUtils.isEmpty((CharSequence)(object3 = ((Locale)object3).getVariant())))) {
                            stringBuilder.append("-");
                            stringBuilder.append((String)object3);
                        }
                        object3 = stringBuilder.toString();
                    }
                }
            }
            httpURLConnection.setRequestProperty(string, (String)object3);
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.connect();
            object3 = httpURLConnection.getOutputStream();
            ((OutputStream)object3).write(byArray);
            ((OutputStream)object3).close();
            int n = httpURLConnection.getResponseCode();
            if (n != 200) {
                object2 = new HttpStatusException("Failed to fetch response", n);
                throw object2;
            }
            object2 = ((zzrg)((zzbh)object2).zzc).zzA().zzb(httpURLConnection.getInputStream());
            ((zzm)object4).close();
            return (ResponseT)((zzrg)object2);
            catch (Throwable throwable) {
                try {
                    ((zzm)object4).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                try {
                    throw throwable;
                }
                catch (IOException iOException322222) {
                    zzak.zza("RecaptchaNetworkMgr", iOException322222);
                    if (!(iOException322222 instanceof MalformedURLException)) break block21;
                    RecaptchaNetworkException recaptchaNetworkException = new RecaptchaNetworkException(String.valueOf(iOException322222.getMessage()), iOException322222);
                    throw recaptchaNetworkException;
                }
            }
        }
        RecaptchaNetworkException recaptchaNetworkException = new RecaptchaNetworkException("Failed to connect to server", iOException322222);
        throw recaptchaNetworkException;
    }

    public final /* synthetic */ zzrg zzc(zzrg zzrg2) throws Exception {
        return this.zzf(zzrg2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static /* synthetic */ HttpURLConnection zzd(zzbh object) throws IOException {
        if (URLUtil.isHttpsUrl((String)((zzbh)object).zza) || URLUtil.isHttpUrl((String)((zzbh)object).zza)) {
            if (URLUtil.isHttpUrl((String)((zzbh)object).zza)) {
                URL uRL = new URL(((zzbh)object).zza);
                return (HttpURLConnection)uRL.openConnection();
            }
        } else {
            object = new MalformedURLException("Recaptcha server url only allows using Http or Https.");
            throw object;
        }
        URL uRL = new URL(((zzbh)object).zza);
        return (HttpsURLConnection)uRL.openConnection();
    }

    public zzbh(String string, ExecutorService executorService, ResponseT ResponseT) {
        this.zza = string;
        this.zzb = executorService;
        this.zzc = ResponseT;
    }

    public final /* synthetic */ void zze(TaskCompletionSource taskCompletionSource, zzrg zzrg2) {
        try {
            taskCompletionSource.setResult(this.zzf(zzrg2));
            return;
        }
        catch (HttpStatusException | RecaptchaNetworkException exception) {
            taskCompletionSource.setException(exception);
            return;
        }
    }
}

