/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzaww;
import com.google.android.gms.internal.zzawx;
import com.google.android.gms.internal.zzawy;
import com.google.android.gms.internal.zzaxb;
import com.google.android.gms.internal.zzaxd;
import com.google.android.gms.internal.zzaxf;
import com.google.android.gms.internal.zzaxg;
import com.google.android.gms.internal.zzaxh;
import com.google.android.gms.internal.zzzv;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzaxa
implements SafetyNetApi {
    private static final String TAG = zzaxa.class.getSimpleName();
    protected static SparseArray<zzaxf> zzbBg;
    protected static long zzbBh;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, final byte[] byArray) {
        return googleApiClient.zza((zzzv.zza)new zzb(this, googleApiClient){

            protected void zza(zzaxb zzaxb2) throws RemoteException {
                zzaxb2.zza(this.zzbBp, byArray);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        return this.zza(googleApiClient, list, string, null);
    }

    public PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, final List<Integer> list, final String string, final String string2) {
        if (list == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zza((zzzv.zza)new zzf(this, googleApiClient){

            protected void zza(zzaxb zzaxb2) throws RemoteException {
                zzaxb2.zza(this.zzbBp, list, 2, string, string2);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, final String string, final int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zza((zzzv.zza)new zzf(this, googleApiClient){

            protected void zza(zzaxb zzaxb2) throws RemoteException {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int n : nArray) {
                    arrayList.add(n);
                }
                zzaxb2.zza(this.zzbBp, arrayList, 1, string, null);
            }
        });
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (zzbBg == null || zzbBh == 0L || SystemClock.elapsedRealtime() - zzbBh >= 1200000L) {
            return true;
        }
        if (zzbBg != null && zzbBg.size() != 0) {
            List<zzaxd> list = new zzaxg(string).zzNU();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzaxd zzaxd2 : list) {
                for (int n : nArray) {
                    zzaxf zzaxf2 = (zzaxf)zzbBg.get(n);
                    if (zzaxf2 != null) {
                        if (!zzaxf2.zzH(zzaxd2.zzmG(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        return new zzaxh(context).zzNZ();
    }

    @Override
    public PendingResult<SafetyNetApi.zzd> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzzv.zza)new zzc(this, googleApiClient){

            protected void zza(zzaxb zzaxb2) throws RemoteException {
                zzaxb2.zzb(this.zzbBp);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.zzb> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzzv.zza)new zzd(this, googleApiClient){

            protected void zza(zzaxb zzaxb2) throws RemoteException {
                zzaxb2.zzc(this.zzbBp);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.zzc> verifyWithRecaptcha(GoogleApiClient googleApiClient, final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.zza((zzzv.zza)new zze(this, googleApiClient){

            protected void zza(zzaxb zzaxb2) throws RemoteException {
                zzaxb2.zza(this.zzbBp, string);
            }
        });
    }

    static class zzh
    implements SafetyNetApi.zzc {
        private final Status zzahq;
        private final com.google.android.gms.safetynet.zzg zzbBw;

        public zzh(Status status, com.google.android.gms.safetynet.zzg zzg2) {
            this.zzahq = status;
            this.zzbBw = zzg2;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    static abstract class zze
    extends zzawx<SafetyNetApi.zzc> {
        protected zzawy zzbBp = new zzaww(){

            @Override
            public void zza(Status status, com.google.android.gms.safetynet.zzg zzg2) {
                zze.this.zzb(new zzh(status, zzg2));
            }
        };

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzc zzbE(Status status) {
            return new zzh(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbE(status);
        }
    }

    static abstract class zzd
    extends zzawx<SafetyNetApi.zzb> {
        protected final zzawy zzbBp = new zzaww(){

            @Override
            public void zza(Status status, com.google.android.gms.safetynet.zze zze2) {
                zzd.this.zzb(new zzg(status, zze2));
            }
        };

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzb zzbD(Status status) {
            return new zzg(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbD(status);
        }
    }

    static class zzg
    implements SafetyNetApi.zzb {
        private final Status zzahq;
        private final com.google.android.gms.safetynet.zze zzbBv;

        public zzg(Status status, com.google.android.gms.safetynet.zze zze2) {
            this.zzahq = status;
            this.zzbBv = zze2;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    static abstract class zzc
    extends zzawx<SafetyNetApi.zzd> {
        protected zzawy zzbBp = new zzaww(){

            @Override
            public void zzc(Status status, boolean bl) {
                zzc.this.zzb(new zzj(status, bl));
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzd zzbC(Status status) {
            return new zzj(status, false);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbC(status);
        }
    }

    static class zzj
    implements SafetyNetApi.zzd {
        private final Status zzahq;
        private final boolean zzXR;

        public zzj(Status status, boolean bl) {
            this.zzahq = status;
            this.zzXR = bl;
        }

        public Status getStatus() {
            return this.zzahq;
        }
    }

    static class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status zzahq;
        private final SafeBrowsingData zzbBx;
        private String zzbBc;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.zzahq = status;
            this.zzbBx = safeBrowsingData;
            this.zzbBc = null;
            if (this.zzbBx != null) {
                this.zzbBc = this.zzbBx.getMetadata();
            } else if (this.zzahq.isSuccess()) {
                this.zzahq = new Status(8);
            }
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getMetadata() {
            return this.zzbBc;
        }

        @Override
        public List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzbBc == null) {
                return arrayList;
            }
            try {
                JSONObject jSONObject = new JSONObject(this.zzbBc);
                jSONArray = jSONObject.getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    int n = Integer.parseInt(jSONObject.getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzawx<SafetyNetApi.SafeBrowsingResult> {
        protected zzawy zzbBp = new zzaww(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(Status status, SafeBrowsingData safeBrowsingData) {
                DataHolder dataHolder = safeBrowsingData.getBlacklistsDataHolder();
                if (dataHolder != null) {
                    try {
                        int n = dataHolder.getCount();
                        if (n != 0) {
                            if (zzbBg != null) {
                                zzbBg.clear();
                            }
                            zzbBg = new SparseArray();
                            for (int i = 0; i < n; ++i) {
                                zzaxf zzaxf2 = new zzaxf(dataHolder, i);
                                zzbBg.put(zzaxf2.getThreatType(), (Object)zzaxf2);
                            }
                            zzbBh = SystemClock.elapsedRealtime();
                        }
                    }
                    finally {
                        if (!dataHolder.isClosed()) {
                            dataHolder.close();
                        }
                    }
                }
                zzf.this.zzb(new zzi(status, safeBrowsingData));
            }
        };

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.SafeBrowsingResult zzbF(Status status) {
            return new zzi(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbF(status);
        }
    }

    static class zza
    implements SafetyNetApi.AttestationResult {
        private final Status zzahq;
        private final com.google.android.gms.safetynet.zza zzbBo;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.zzahq = status;
            this.zzbBo = zza2;
        }

        public Status getStatus() {
            return this.zzahq;
        }

        @Override
        public String getJwsResult() {
            if (this.zzbBo == null) {
                return null;
            }
            return this.zzbBo.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzawx<SafetyNetApi.AttestationResult> {
        protected zzawy zzbBp = new zzaww(){

            @Override
            public void zza(Status status, com.google.android.gms.safetynet.zza zza2) {
                zzb.this.zzb(new zza(status, zza2));
            }
        };

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.AttestationResult zzbB(Status status) {
            return new zza(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbB(status);
        }
    }
}

