/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzaad;
import com.google.android.gms.internal.zzazr;
import com.google.android.gms.internal.zzazs;
import com.google.android.gms.internal.zzazt;
import com.google.android.gms.internal.zzazw;
import com.google.android.gms.internal.zzazy;
import com.google.android.gms.internal.zzbaa;
import com.google.android.gms.internal.zzbab;
import com.google.android.gms.internal.zzbac;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzazv
implements SafetyNetApi {
    private static final String TAG = zzazv.class.getSimpleName();
    protected static SparseArray<zzbaa> zzbDk;
    protected static long zzbDl;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzazv.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.AttestationResult> zza(GoogleApiClient googleApiClient, final byte[] byArray, final String string) {
        return googleApiClient.zza((zzaad.zza)new zzb(googleApiClient){

            protected void zza(zzazw zzazw2) throws RemoteException {
                zzazw2.zzb(this.zzbDu, byArray, string);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        return this.zza(googleApiClient, list, string, null);
    }

    public PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, final List<Integer> list, final String string, final String string2) {
        if (list == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zza((zzaad.zza)new zzf(this, googleApiClient){

            protected void zza(zzazw zzazw2) throws RemoteException {
                zzazw2.zza(this.zzbDu, list, 2, string, string2);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, int ... nArray) {
        return zzazv.zza(googleApiClient, string, 1, null, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, final String string, final int n, final String string2, final int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zza((zzaad.zza)new zzf(googleApiClient){

            protected void zza(zzazw zzazw2) throws RemoteException {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int n2 : nArray) {
                    arrayList.add(n2);
                }
                zzazw2.zza(this.zzbDu, arrayList, n, string, string2);
            }
        });
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (zzbDk == null || zzbDl == 0L || SystemClock.elapsedRealtime() - zzbDl >= 1200000L) {
            return true;
        }
        if (zzbDk != null && zzbDk.size() != 0) {
            List<zzazy> list = new zzbab(string).zzPB();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzazy zzazy2 : list) {
                for (int n : nArray) {
                    zzbaa zzbaa2 = (zzbaa)zzbDk.get(n);
                    if (zzbaa2 != null) {
                        if (!zzbaa2.zzI(zzazy2.zznr(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        return new zzbac(context).zzPG();
    }

    @Override
    public PendingResult<SafetyNetApi.zzf> enableVerifyApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzaad.zza)new zzc(this, googleApiClient){

            protected void zza(zzazw zzazw2) throws RemoteException {
                zzazw2.zzd(this.zzbDu);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.zzc> listHarmfulApps(GoogleApiClient googleApiClient) {
        return googleApiClient.zza((zzaad.zza)new zzd(this, googleApiClient){

            protected void zza(zzazw zzazw2) throws RemoteException {
                zzazw2.zze(this.zzbDu);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.zzd> verifyWithRecaptcha(GoogleApiClient googleApiClient, final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
        }
        return googleApiClient.zza((zzaad.zza)new zze(this, googleApiClient){

            protected void zza(zzazw zzazw2) throws RemoteException {
                zzazw2.zza(this.zzbDu, string);
            }
        });
    }

    static class zzh
    implements SafetyNetApi.zzd {
        private final Status zzair;
        private final com.google.android.gms.safetynet.zzg zzbDB;

        public zzh(Status status, com.google.android.gms.safetynet.zzg zzg2) {
            this.zzair = status;
            this.zzbDB = zzg2;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    static abstract class zze
    extends zzazs<SafetyNetApi.zzd> {
        protected zzazt zzbDu = new zzazr(){

            @Override
            public void zza(Status status, com.google.android.gms.safetynet.zzg zzg2) {
                zze.this.zzb(new zzh(status, zzg2));
            }
        };

        public zze(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzd zzbH(Status status) {
            return new zzh(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbH(status);
        }
    }

    static abstract class zzd
    extends zzazs<SafetyNetApi.zzc> {
        protected final zzazt zzbDu = new zzazr(){

            @Override
            public void zza(Status status, com.google.android.gms.safetynet.zze zze2) {
                zzd.this.zzb(new zzg(status, zze2));
            }
        };

        public zzd(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzc zzbG(Status status) {
            return new zzg(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbG(status);
        }
    }

    static class zzg
    implements SafetyNetApi.zzc {
        private final Status zzair;
        private final com.google.android.gms.safetynet.zze zzbDA;

        public zzg(Status status, com.google.android.gms.safetynet.zze zze2) {
            this.zzair = status;
            this.zzbDA = zze2;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    static abstract class zzc
    extends zzazs<SafetyNetApi.zzf> {
        protected zzazt zzbDu = new zzazr(){

            @Override
            public void zzc(Status status, boolean bl) {
                zzc.this.zzb(new zzj(status, bl));
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.zzf zzbF(Status status) {
            return new zzj(status, false);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbF(status);
        }
    }

    static class zzj
    implements SafetyNetApi.zzf {
        private final Status zzair;
        private final boolean zzYM;

        public zzj(Status status, boolean bl) {
            this.zzair = status;
            this.zzYM = bl;
        }

        public Status getStatus() {
            return this.zzair;
        }
    }

    static class zzi
    implements SafetyNetApi.SafeBrowsingResult {
        private Status zzair;
        private final SafeBrowsingData zzbDC;
        private String zzbDg;

        public zzi(Status status, SafeBrowsingData safeBrowsingData) {
            this.zzair = status;
            this.zzbDC = safeBrowsingData;
            this.zzbDg = null;
            if (this.zzbDC != null) {
                this.zzbDg = this.zzbDC.getMetadata();
            } else if (this.zzair.isSuccess()) {
                this.zzair = new Status(8);
            }
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getMetadata() {
            return this.zzbDg;
        }

        @Override
        public List<SafeBrowsingThreat> getDetectedThreats() {
            JSONArray jSONArray;
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.zzbDg == null) {
                return arrayList;
            }
            try {
                JSONObject jSONObject = new JSONObject(this.zzbDg);
                jSONArray = jSONObject.getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    int n = Integer.parseInt(jSONObject.getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {}
            }
            return arrayList;
        }
    }

    static abstract class zzf
    extends zzazs<SafetyNetApi.SafeBrowsingResult> {
        protected zzazt zzbDu = new zzazr(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(Status status, SafeBrowsingData safeBrowsingData) {
                DataHolder dataHolder = safeBrowsingData.getBlacklistsDataHolder();
                if (dataHolder != null) {
                    try {
                        int n = dataHolder.getCount();
                        if (n != 0) {
                            if (zzbDk != null) {
                                zzbDk.clear();
                            }
                            zzbDk = new SparseArray();
                            for (int i = 0; i < n; ++i) {
                                zzbaa zzbaa2 = new zzbaa(dataHolder, i);
                                zzbDk.put(zzbaa2.getThreatType(), (Object)zzbaa2);
                            }
                            zzbDl = SystemClock.elapsedRealtime();
                        }
                    }
                    finally {
                        if (!dataHolder.isClosed()) {
                            dataHolder.close();
                        }
                    }
                }
                zzf.this.zzb(new zzi(status, safeBrowsingData));
            }
        };

        public zzf(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.SafeBrowsingResult zzbI(Status status) {
            return new zzi(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbI(status);
        }
    }

    static class zza
    implements SafetyNetApi.AttestationResult {
        private final Status zzair;
        private final com.google.android.gms.safetynet.zza zzbDt;

        public zza(Status status, com.google.android.gms.safetynet.zza zza2) {
            this.zzair = status;
            this.zzbDt = zza2;
        }

        public Status getStatus() {
            return this.zzair;
        }

        @Override
        public String getJwsResult() {
            if (this.zzbDt == null) {
                return null;
            }
            return this.zzbDt.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzazs<SafetyNetApi.AttestationResult> {
        protected zzazt zzbDu = new zzazr(){

            @Override
            public void zza(Status status, com.google.android.gms.safetynet.zza zza2) {
                zzb.this.zzb(new zza(status, zza2));
            }
        };

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.AttestationResult zzbE(Status status) {
            return new zza(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzbE(status);
        }
    }
}

