/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.safetynet;

import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzbej;
import com.google.android.gms.safetynet.zzh;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class SafeBrowsingData
extends zzbej {
    private static final String TAG = SafeBrowsingData.class.getSimpleName();
    public static final Parcelable.Creator<SafeBrowsingData> CREATOR = new zzh();
    private String zzjxo;
    private DataHolder zzjxp;
    private ParcelFileDescriptor zzcoi;
    private byte[] zzjxq;
    private File zzfsz;

    public SafeBrowsingData(String string, DataHolder dataHolder, ParcelFileDescriptor parcelFileDescriptor) {
        this.zzjxo = string;
        this.zzjxp = dataHolder;
        this.zzcoi = parcelFileDescriptor;
    }

    public SafeBrowsingData(String string) {
        this(string, null, null);
    }

    public SafeBrowsingData(String string, DataHolder dataHolder) {
        this(string, dataHolder, null);
    }

    public SafeBrowsingData() {
        this(null, null, null);
    }

    public String getMetadata() {
        return this.zzjxo;
    }

    public DataHolder getBlacklistsDataHolder() {
        return this.zzjxp;
    }

    public ParcelFileDescriptor getFileDescriptor() {
        return this.zzcoi;
    }

    public void setBlacklists(byte[] byArray) {
        this.zzjxq = byArray;
    }

    public byte[] getBlacklists() {
        if (this.zzcoi == null) {
            return null;
        }
        DataInputStream dataInputStream = new DataInputStream((InputStream)new ParcelFileDescriptor.AutoCloseInputStream(this.zzcoi));
        try {
            byte[] byArray = new byte[dataInputStream.readInt()];
            dataInputStream.read(byArray);
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            SafeBrowsingData.zza(dataInputStream);
            this.zzcoi = null;
        }
    }

    public void writeToParcel(Parcel parcel, int n) {
        FileOutputStream fileOutputStream;
        boolean bl = false;
        if (this.zzcoi == null && this.zzjxq != null && (fileOutputStream = this.zzajl()) != null) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
            DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
            try {
                dataOutputStream.writeInt(this.zzjxq.length);
                dataOutputStream.write(this.zzjxq);
                bl = true;
            }
            catch (IOException iOException) {
            }
            finally {
                SafeBrowsingData.zza(dataOutputStream);
            }
        }
        if (!bl) {
            zzh.zza(this, parcel, n);
        } else {
            zzh.zza(this, parcel, n | 1);
        }
        this.zzcoi = null;
    }

    private static void zza(Closeable closeable) {
        try {
            closeable.close();
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void setTempDir(File file) {
        if (file != null) {
            this.zzfsz = file;
        }
    }

    private final FileOutputStream zzajl() {
        FileOutputStream fileOutputStream;
        if (this.zzfsz == null) {
            return null;
        }
        File file = null;
        try {
            file = File.createTempFile("xlb", ".tmp", this.zzfsz);
            fileOutputStream = new FileOutputStream(file);
            this.zzcoi = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        }
        catch (IOException iOException) {
            return null;
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
        return fileOutputStream;
    }
}

