/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.safetynet;

import android.content.Context;
import android.text.TextUtils;
import androidx.annotation.Nullable;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.internal.BaseImplementation;
import com.google.android.gms.internal.safetynet.zzi;
import com.google.android.gms.internal.safetynet.zzj;
import com.google.android.gms.internal.safetynet.zzk;
import com.google.android.gms.internal.safetynet.zzl;
import com.google.android.gms.internal.safetynet.zzm;
import com.google.android.gms.internal.safetynet.zzn;
import com.google.android.gms.internal.safetynet.zzo;
import com.google.android.gms.safetynet.SafetyNet;
import com.google.android.gms.safetynet.SafetyNetApi;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.Tasks;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class zzae
implements SafetyNetApi {
    private static final String zza = zzae.class.getSimpleName();

    @Override
    public final PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, byte[] byArray) {
        return zzae.zza(googleApiClient, byArray, null);
    }

    public static PendingResult<SafetyNetApi.AttestationResult> zza(GoogleApiClient googleApiClient, byte[] byArray, @Nullable String string) {
        zzi zzi2 = new zzi(googleApiClient, byArray, string);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzi2);
    }

    @Override
    public final PendingResult<SafetyNetApi.VerifyAppsUserResult> enableVerifyApps(GoogleApiClient googleApiClient) {
        zzm zzm2 = new zzm(this, googleApiClient);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzm2);
    }

    @Override
    public final PendingResult<SafetyNetApi.VerifyAppsUserResult> isVerifyAppsEnabled(GoogleApiClient googleApiClient) {
        zzl zzl2 = new zzl(this, googleApiClient);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzl2);
    }

    @Override
    public final PendingResult<SafetyNetApi.HarmfulAppsResult> listHarmfulApps(GoogleApiClient googleApiClient) {
        zzn zzn2 = new zzn(this, googleApiClient);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzn2);
    }

    @Override
    public final PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        Object object;
        if (list == null) {
            object = new IllegalArgumentException("Null threatTypes in lookupUri");
            throw object;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            object = new IllegalArgumentException("Null or empty uri in lookupUri");
            throw object;
        }
        zzj zzj2 = new zzj((zzae)object, googleApiClient, list, string, null);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzj2);
    }

    @Override
    public final PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, String string, String string2, int ... nArray) {
        return zzae.zzb(googleApiClient, string, 1, string2, nArray);
    }

    public static PendingResult<SafetyNetApi.SafeBrowsingResult> zzb(GoogleApiClient object, String string, int n, String string2, int ... nArray) {
        if (nArray.length == 0) {
            object = new IllegalArgumentException("Null threatTypes in lookupUri");
            throw object;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            object = new IllegalArgumentException("Null or empty uri in lookupUri");
            throw object;
        }
        zzk zzk2 = new zzk((GoogleApiClient)object, nArray, n, string, string2);
        return object.enqueue((BaseImplementation.ApiMethodImpl)zzk2);
    }

    @Override
    public final PendingResult<SafetyNetApi.RecaptchaTokenResult> verifyWithRecaptcha(GoogleApiClient googleApiClient, String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            Object object = new IllegalArgumentException("Null or empty site key in verifyWithRecaptcha");
            throw object;
        }
        zzo zzo2 = new zzo((zzae)object, googleApiClient, string);
        return googleApiClient.enqueue((BaseImplementation.ApiMethodImpl)zzo2);
    }

    @Override
    public final boolean isVerifyAppsEnabled(Context context) {
        Task<SafetyNetApi.VerifyAppsUserResponse> task = SafetyNet.getClient(context).isVerifyAppsEnabled();
        try {
            Tasks.await(task, (long)15000L, (TimeUnit)TimeUnit.MILLISECONDS);
            return ((SafetyNetApi.VerifyAppsUserResponse)((Object)task.getResult())).isVerifyAppsEnabled();
        }
        catch (InterruptedException | ExecutionException | TimeoutException exception) {
            return false;
        }
    }
}

