/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.os.RemoteException;
import android.os.SystemClock;
import android.text.TextUtils;
import android.util.SparseArray;
import com.google.android.gms.common.api.GoogleApiClient;
import com.google.android.gms.common.api.PendingResult;
import com.google.android.gms.common.api.Result;
import com.google.android.gms.common.api.Status;
import com.google.android.gms.common.data.DataHolder;
import com.google.android.gms.internal.zzpm;
import com.google.android.gms.internal.zzvd;
import com.google.android.gms.internal.zzve;
import com.google.android.gms.internal.zzvf;
import com.google.android.gms.internal.zzvi;
import com.google.android.gms.internal.zzvk;
import com.google.android.gms.internal.zzvm;
import com.google.android.gms.internal.zzvn;
import com.google.android.gms.internal.zzvo;
import com.google.android.gms.safetynet.AttestationData;
import com.google.android.gms.safetynet.SafeBrowsingData;
import com.google.android.gms.safetynet.SafeBrowsingThreat;
import com.google.android.gms.safetynet.SafetyNetApi;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class zzvh
implements SafetyNetApi {
    private static final String TAG = zzvh.class.getSimpleName();
    protected static SparseArray<zzvm> asX;
    protected static long asY;

    @Override
    public PendingResult<SafetyNetApi.AttestationResult> attest(GoogleApiClient googleApiClient, final byte[] byArray) {
        return googleApiClient.zzc((zzpm.zza)new zzb(googleApiClient){

            protected void zza(zzvi zzvi2) throws RemoteException {
                zzvi2.zza(this.atg, byArray);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, List<Integer> list, String string) {
        return this.zza(googleApiClient, list, string, null);
    }

    public PendingResult<SafetyNetApi.SafeBrowsingResult> zza(GoogleApiClient googleApiClient, final List<Integer> list, final String string, final String string2) {
        if (list == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzc((zzpm.zza)new zzc(googleApiClient){

            protected void zza(zzvi zzvi2) throws RemoteException {
                zzvi2.zza(this.atg, list, 2, string, string2);
            }
        });
    }

    @Override
    public PendingResult<SafetyNetApi.SafeBrowsingResult> lookupUri(GoogleApiClient googleApiClient, final String string, final int ... nArray) {
        if (nArray.length == 0) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        return googleApiClient.zzc((zzpm.zza)new zzc(googleApiClient){

            protected void zza(zzvi zzvi2) throws RemoteException {
                ArrayList<Integer> arrayList = new ArrayList<Integer>();
                for (int n : nArray) {
                    arrayList.add(n);
                }
                zzvi2.zza(this.atg, arrayList, 1, string, null);
            }
        });
    }

    @Override
    public boolean lookupUriInLocalBlacklist(String string, int ... nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Null threatTypes in lookupUri");
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            throw new IllegalArgumentException("Null or empty uri in lookupUri");
        }
        if (asX == null || asY == 0L || SystemClock.elapsedRealtime() - asY >= 1200000L) {
            return true;
        }
        if (asX != null && asX.size() != 0) {
            List<zzvk> list = new zzvn(string).zzbze();
            if (list == null || list.isEmpty()) {
                return true;
            }
            for (zzvk zzvk2 : list) {
                for (int n : nArray) {
                    zzvm zzvm2 = (zzvm)asX.get(n);
                    if (zzvm2 != null) {
                        if (!zzvm2.zzag(zzvk2.zzyw(4).getBytes())) continue;
                        return true;
                    }
                    return true;
                }
            }
            return false;
        }
        return true;
    }

    @Override
    public boolean isVerifyAppsEnabled(Context context) {
        return new zzvo(context).zzbzj();
    }

    static class zzd
    implements SafetyNetApi.SafeBrowsingResult {
        private Status bY;
        private final SafeBrowsingData atj;
        private String asT;

        public zzd(Status status, SafeBrowsingData safeBrowsingData) {
            this.bY = status;
            this.atj = safeBrowsingData;
            this.asT = null;
            if (this.atj != null) {
                this.asT = this.atj.getMetadata();
            } else if (this.bY.isSuccess()) {
                this.bY = new Status(8);
            }
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public String getMetadata() {
            return this.asT;
        }

        @Override
        public List<SafeBrowsingThreat> getDetectedThreats() {
            ArrayList<SafeBrowsingThreat> arrayList = new ArrayList<SafeBrowsingThreat>();
            if (this.asT == null) {
                return arrayList;
            }
            JSONArray jSONArray = null;
            try {
                JSONObject jSONObject = new JSONObject(this.asT);
                jSONArray = jSONObject.getJSONArray("matches");
            }
            catch (JSONException jSONException) {
                return arrayList;
            }
            for (int i = 0; i < jSONArray.length(); ++i) {
                try {
                    JSONObject jSONObject = jSONArray.getJSONObject(i);
                    int n = Integer.parseInt(jSONObject.getString("threat_type"));
                    SafeBrowsingThreat safeBrowsingThreat = new SafeBrowsingThreat(n);
                    arrayList.add(safeBrowsingThreat);
                    continue;
                }
                catch (JSONException jSONException) {
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return arrayList;
        }
    }

    static abstract class zzc
    extends zzve<SafetyNetApi.SafeBrowsingResult> {
        protected zzvf atg = new zzvd(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void zza(Status status, SafeBrowsingData safeBrowsingData) {
                DataHolder dataHolder = safeBrowsingData.getBlacklistsDataHolder();
                if (dataHolder != null) {
                    try {
                        int n = dataHolder.getCount();
                        if (n != 0) {
                            if (asX != null) {
                                asX.clear();
                            }
                            asX = new SparseArray();
                            for (int i = 0; i < n; ++i) {
                                zzvm zzvm2 = new zzvm(dataHolder, i);
                                asX.put(zzvm2.getThreatType(), (Object)zzvm2);
                            }
                            asY = SystemClock.elapsedRealtime();
                        }
                    }
                    finally {
                        if (!dataHolder.isClosed()) {
                            dataHolder.close();
                        }
                    }
                }
                zzc.this.zzc(new zzd(status, safeBrowsingData));
            }
        };

        public zzc(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.SafeBrowsingResult zzdx(Status status) {
            return new zzd(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzdx(status);
        }
    }

    static class zza
    implements SafetyNetApi.AttestationResult {
        private final Status bY;
        private final AttestationData atf;

        public zza(Status status, AttestationData attestationData) {
            this.bY = status;
            this.atf = attestationData;
        }

        public Status getStatus() {
            return this.bY;
        }

        @Override
        public String getJwsResult() {
            if (this.atf == null) {
                return null;
            }
            return this.atf.getJwsResult();
        }
    }

    static abstract class zzb
    extends zzve<SafetyNetApi.AttestationResult> {
        protected zzvf atg = new zzvd(){

            @Override
            public void zza(Status status, AttestationData attestationData) {
                zzb.this.zzc(new zza(status, attestationData));
            }
        };

        public zzb(GoogleApiClient googleApiClient) {
            super(googleApiClient);
        }

        protected SafetyNetApi.AttestationResult zzdw(Status status) {
            return new zza(status, null);
        }

        protected /* synthetic */ Result zzc(Status status) {
            return this.zzdw(status);
        }
    }
}

