/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.net.Uri;
import android.text.TextUtils;
import com.google.android.gms.internal.zzxf;
import com.google.android.gms.internal.zzxg;
import java.io.ByteArrayOutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class zzxi {
    private static final String TAG = zzxi.class.getSimpleName();
    private static final char[] aCH = "0123456789ABCDEF".toCharArray();
    private static final Pattern aCI = Pattern.compile("/\\.\\.");
    private static final Pattern aCJ = Pattern.compile("0[1-7][0-7]*");
    private static final Pattern aCK = Pattern.compile("0x[0-9a-f]*", 2);
    private static final Pattern aCL = Pattern.compile("^((?:0x[0-9a-f]+|[0-9\\\\.])+)$", 2);
    private final String zzae;
    private final String aCM;
    private final String aCN;
    private final int aCO;
    private final String mPath;
    private final String zzapy;

    public zzxi(String string) {
        String string2;
        String string3;
        if (!zzxi.zzoi(string)) {
            this.zzae = null;
            this.aCM = null;
            this.aCN = null;
            this.aCO = -1;
            this.mPath = null;
            this.zzapy = null;
            return;
        }
        string = string.replaceAll("^\\s+", "").replaceAll("\\s+$", "");
        int n = (string = string.replaceAll("[\\t\\n\\r]", "")).indexOf(35);
        zza zza2 = new zza(string = n != -1 ? string.substring(0, n) : string);
        if (!zza2.zzccw()) {
            this.zzae = null;
            this.aCM = null;
            this.aCN = null;
            this.aCO = -1;
            this.mPath = null;
            this.zzapy = null;
            return;
        }
        this.aCM = zza2.getScheme();
        this.aCO = zza2.getPort();
        if (this.aCM != null) {
            string3 = this.aCM;
            string = string.replaceAll(new StringBuilder(2 + String.valueOf(string3).length()).append("^").append(string3).append(":").toString(), "");
        }
        string = string.replaceAll("^/+", "");
        string = zzxi.zzok(string);
        string3 = null;
        int n2 = string.indexOf(63);
        if (n2 != -1) {
            int n3 = n2 + 1;
            string3 = n3 < string.length() ? string.substring(n3) : "";
            string = string.substring(0, n2);
        }
        if (TextUtils.isEmpty((CharSequence)(string2 = this.zzoe(string)))) {
            this.zzae = null;
            this.aCN = null;
            this.mPath = null;
            this.zzapy = null;
            return;
        }
        String string4 = this.zzoh(string);
        this.aCN = zzxi.zzoj(string2);
        this.mPath = zzxi.zzoj(string4);
        this.zzapy = !TextUtils.isEmpty((CharSequence)string3) ? zzxi.zzoj(string3) : string3;
        this.zzae = string;
    }

    private String zzoe(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        int n = string2.indexOf(47);
        string2 = n != -1 ? string2.substring(0, n) : string2;
        int n2 = string2.indexOf(64);
        String string3 = string2 = n2 != -1 ? string2.substring(n2 + 1) : string2;
        if (this.aCO != -1) {
            int n3 = this.aCO;
            string2 = string2.replaceAll(new StringBuilder(13).append(":").append(n3).append("$").toString(), "");
        }
        string2 = string2.replaceAll("^\\.*", "").replaceAll("\\.*$", "");
        String string4 = zzxi.zzof(string2 = string2.replaceAll("\\.+", "."));
        if (string4 != null) {
            string2 = string4;
        }
        return string2.toLowerCase(Locale.getDefault());
    }

    private static String zzof(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string.replaceAll("^\\[", "").replaceAll("\\]$", "");
        if (zzxg.zznw(string2)) {
            InetAddress inetAddress = zzxg.zzod(string2);
            String string3 = zzxg.zza(inetAddress);
            return string3.contains(":") ? String.format("[%s]", string3) : string3;
        }
        if (TextUtils.isDigitsOnly((CharSequence)string)) {
            String string4 = zzxi.zzog(string);
            if (!TextUtils.isEmpty((CharSequence)string4)) {
                return string4;
            }
        } else if (aCL.matcher(string2).find()) {
            int n;
            Matcher matcher = aCJ.matcher(string2);
            StringBuffer stringBuffer = new StringBuffer();
            while (matcher.find()) {
                n = Integer.parseInt(matcher.group(), 8);
                matcher.appendReplacement(stringBuffer, new StringBuilder(11).append(n).toString());
            }
            matcher.appendTail(stringBuffer);
            matcher = aCK.matcher(stringBuffer.toString());
            stringBuffer = new StringBuffer();
            while (matcher.find()) {
                n = Integer.parseInt(matcher.group().substring(2), 16);
                matcher.appendReplacement(stringBuffer, new StringBuilder(11).append(n).toString());
            }
            matcher.appendTail(stringBuffer);
            String string5 = stringBuffer.toString();
            return string5.contains(":") ? String.format("[%s]", string5) : string5;
        }
        return null;
    }

    private static String zzog(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            byte[] byArray;
            BigInteger bigInteger = new BigInteger(string);
            byte[] byArray2 = bigInteger.toByteArray();
            if (byArray2.length < 4) {
                return null;
            }
            byte[] byArray3 = Arrays.copyOfRange(byArray2, byArray2.length - 4, byArray2.length);
            byte[] byArray4 = new byte[]{0, byArray3[0], byArray3[1], byArray3[2], byArray3[3]};
            BigInteger bigInteger2 = new BigInteger(byArray4);
            if (bigInteger.equals(bigInteger2)) {
                return Inet4Address.getByAddress(byArray3).getHostAddress();
            }
            if (byArray2.length >= 16) {
                byArray = Arrays.copyOfRange(byArray2, byArray2.length - 16, byArray2.length);
            } else {
                int n;
                byte[] byArray5 = new byte[16];
                int n2 = 0;
                int n3 = 16 - byArray2.length;
                for (n = 1; n <= n3; ++n) {
                    byArray5[n2++] = 0;
                }
                for (n = 0; n < byArray2.length; ++n) {
                    byArray5[n2++] = byArray2[n];
                }
                byArray = byArray5;
            }
            return String.format("[%s]", Inet6Address.getByAddress(byArray).getHostAddress());
        }
        catch (NumberFormatException numberFormatException) {
            zzxi.zza(numberFormatException);
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            zzxi.zza(arrayIndexOutOfBoundsException);
            return null;
        }
        catch (UnknownHostException unknownHostException) {
            zzxi.zza(unknownHostException);
            return null;
        }
    }

    private String zzoh(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        int n = string.indexOf(47);
        String string2 = n != -1 ? string.substring(n) : "/";
        string2 = string2.replaceAll("/\\./", "/");
        if (aCI.matcher(string2 = string2.replaceAll("/\\.$", "/")).find()) {
            try {
                URI uRI = new URI(this.aCM, "host", string2, null);
                string2 = uRI.normalize().getRawPath();
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        string2 = string2.replaceAll("/+", "/");
        return string2;
    }

    public List<String> zzccr() {
        List<String> list;
        if (TextUtils.isEmpty((CharSequence)this.zzae)) {
            return null;
        }
        String string = zzxi.zzof(this.aCN);
        if (string != null) {
            list = new ArrayList<String>();
            list.add(string);
        } else {
            list = this.zzcct();
        }
        if (list == null || list.isEmpty()) {
            return null;
        }
        List<String> list2 = this.zzccu();
        if (list2 == null || list2.isEmpty()) {
            return null;
        }
        LinkedList<String> linkedList = new LinkedList<String>();
        for (String string2 : list) {
            for (String string3 : list2) {
                String string4 = String.valueOf(string2);
                String string5 = String.valueOf(string3);
                linkedList.add(string5.length() != 0 ? string4.concat(string5) : new String(string4));
            }
        }
        return !linkedList.isEmpty() ? linkedList : null;
    }

    public List<zzxf> zzccs() {
        List<String> list = this.zzccr();
        if (list == null || list.isEmpty()) {
            return null;
        }
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-256");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            zzxi.zza(noSuchAlgorithmException);
        }
        if (messageDigest == null) {
            return null;
        }
        ArrayList<zzxf> arrayList = new ArrayList<zzxf>(list.size());
        for (String string : list) {
            if (TextUtils.isEmpty((CharSequence)string)) continue;
            try {
                byte[] byArray = messageDigest.digest(string.getBytes("UTF-8"));
                arrayList.add(new zzxf(byArray));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                zzxi.zza(unsupportedEncodingException);
            }
            messageDigest.reset();
        }
        return !arrayList.isEmpty() ? arrayList : null;
    }

    private List<String> zzcct() {
        if (TextUtils.isEmpty((CharSequence)this.aCN)) {
            return null;
        }
        boolean bl = false;
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = this.aCN.toCharArray();
        for (int i = cArray.length - 2; i > 0 && arrayList.size() < 4; --i) {
            if (cArray[i] != '.') continue;
            if (bl) {
                arrayList.add(this.aCN.substring(i + 1));
                continue;
            }
            bl = true;
        }
        arrayList.add(this.aCN);
        return arrayList;
    }

    private List<String> zzccu() {
        if (TextUtils.isEmpty((CharSequence)this.mPath)) {
            return null;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        char[] cArray = this.mPath.toCharArray();
        for (int i = 0; i < cArray.length && arrayList.size() < 4; ++i) {
            if (cArray[i] != '/') continue;
            arrayList.add(this.mPath.substring(0, i + 1));
        }
        if (!arrayList.isEmpty() && !((String)arrayList.get(arrayList.size() - 1)).equals(this.mPath)) {
            arrayList.add(this.mPath);
        }
        if (!TextUtils.isEmpty((CharSequence)this.zzapy)) {
            String string = this.mPath;
            String string2 = this.zzapy;
            arrayList.add(new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("?").append(string2).toString());
        }
        return arrayList;
    }

    private static boolean zzoi(String string) {
        return !TextUtils.isEmpty((CharSequence)string);
    }

    private static String zzoj(String string) {
        byte[] byArray;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        try {
            byArray = string.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < byArray.length; ++i) {
            char c = (char)(byArray[i] & 0xFF);
            if (c <= ' ' || c > '~' || c == '#' || c == '%') {
                stringBuilder.append("%");
                stringBuilder.append(aCH[c >>> 4]);
                stringBuilder.append(aCH[c & 0xF]);
                continue;
            }
            stringBuilder.append(c);
        }
        return stringBuilder.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f';
    }

    private static String zzok(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return null;
        }
        String string2 = string;
        String string3 = null;
        int n = 1024;
        for (int i = 0; !string2.equals(string3) && i < 1024; ++i) {
            string3 = string2;
            string2 = zzxi.zzol(string3);
        }
        return string2;
    }

    private static String zzol(String string) {
        byte[] byArray;
        Object object;
        try {
            object = string.replace("\\x", "%");
            byArray = ((String)object).getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
        object = new ByteArrayOutputStream(byArray.length);
        for (int i = 0; i < byArray.length; ++i) {
            byte by = byArray[i];
            char c = (char)(by & 0xFF);
            if (c >= '\u0080') {
                ((ByteArrayOutputStream)object).write(by);
                continue;
            }
            Byte by2 = zzxi.zzc(byArray, i);
            if (by2 != null) {
                ((ByteArrayOutputStream)object).write(by2.byteValue());
                i += 2;
                continue;
            }
            ((ByteArrayOutputStream)object).write(by);
        }
        try {
            return new String(((ByteArrayOutputStream)object).toByteArray(), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private static Byte zzc(byte[] byArray, int n) {
        if (n + 2 >= byArray.length) {
            return null;
        }
        char c = (char)(byArray[n] & 0xFF);
        if (c != '%') {
            return null;
        }
        char c2 = (char)(byArray[n + 1] & 0xFF);
        char c3 = (char)(byArray[n + 2] & 0xFF);
        if (zzxi.isHexDigit(c2) && zzxi.isHexDigit(c3)) {
            byte by = (byte)(Integer.parseInt(new StringBuilder(1).append(c2).toString(), 16) * 16 + Integer.parseInt(new StringBuilder(1).append(c3).toString(), 16));
            return by;
        }
        return null;
    }

    private static final void zza(Exception exception) {
    }

    private static class zza {
        private static final String[] aCP = new String[]{"http", "https", "ftp"};
        private final String gl;
        private final Uri aCQ;
        private final URI aCR;
        private final String aCM;
        private final Boolean aCS;
        private final Integer aCT;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private zza(String string) {
            this.gl = string;
            this.aCQ = Uri.parse((String)this.gl);
            try {
                URI uRI = new URI(this.gl);
            }
            catch (URISyntaxException uRISyntaxException) {
                Object var2_3 = null;
            }
            finally {
                this.aCR = null;
            }
            this.aCM = this.getScheme();
            this.aCS = this.zzccw();
            this.aCT = this.zzccv();
        }

        private String getScheme() {
            if (this.aCM != null) {
                return this.aCM;
            }
            String string = null;
            if (this.aCQ != null) {
                string = this.aCQ.getScheme();
            }
            if (TextUtils.isEmpty(string)) {
            }
            if (TextUtils.isEmpty((CharSequence)string) && !TextUtils.isEmpty((CharSequence)this.gl)) {
                String string2;
                int n = this.gl.indexOf(":");
                if (n != -1 && zza.zzom(string2 = this.gl.substring(0, n).toLowerCase(Locale.US))) {
                    string = string2;
                }
                if (TextUtils.isEmpty((CharSequence)string)) {
                    string = this.gl.startsWith("www.") ? "http" : "http";
                }
            }
            return string != null ? string.toLowerCase(Locale.US) : null;
        }

        private int getPort() {
            return this.aCT;
        }

        private int zzccv() {
            if (this.aCT != null) {
                return this.aCT;
            }
            int n = -1;
            if (this.aCQ != null && (n = this.aCQ.getPort()) != -1) {
                return n;
            }
            return -1;
        }

        private boolean zzccw() {
            if (this.aCS != null) {
                return this.aCS;
            }
            return zza.zzom(this.aCM);
        }

        private static boolean zzom(String string) {
            if (TextUtils.isEmpty((CharSequence)string)) {
                return false;
            }
            for (int i = 0; i < aCP.length; ++i) {
                if (!aCP[i].equals(string)) continue;
                return true;
            }
            return false;
        }
    }
}

