/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzac;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzh;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzh<TResult> zzh2 = new zzh<TResult>();
        zzh2.setResult(TResult);
        return zzh2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzh zzh2 = new zzh();
        zzh2.setException(exception);
        return zzh2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, final @NonNull Callable<TResult> callable) {
        zzac.zzb((Object)executor, (Object)"Executor must not be null");
        zzac.zzb(callable, (Object)"Callback must not be null");
        final zzh zzh2 = new zzh();
        executor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    zzh2.setResult(callable.call());
                }
                catch (Exception exception) {
                    zzh2.setException(exception);
                }
            }
        });
        return zzh2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        zzac.zzye();
        zzac.zzb(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza();
        Tasks.zza(task, zza2);
        zza2.await();
        return Tasks.zzb(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        zzac.zzye();
        zzac.zzb(task, (Object)"Task must not be null");
        zzac.zzb((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zzb(task);
        }
        zza zza2 = new zza();
        Tasks.zza(task, zza2);
        if (!zza2.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zzb(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        Task<?> task2;
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        for (Task<?> task2 : collection) {
            if (task2 != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        zzh zzh2 = new zzh();
        task2 = new zzc(collection.size(), zzh2);
        for (Task<?> task3 : collection) {
            Tasks.zza(task3, (zzb)((Object)task2));
        }
        return zzh2;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zzb(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.zzbND, zzb2);
        task.addOnFailureListener(TaskExecutors.zzbND, (OnFailureListener)zzb2);
    }

    private Tasks() {
    }

    private static final class zzc
    implements zzb {
        private final Object zzrJ = new Object();
        private final int zzbNJ;
        private final zzh<Void> zzbNC;
        private int zzbNK;
        private int zzbNL;
        private Exception zzbNH;

        public zzc(int n, zzh<Void> zzh2) {
            this.zzbNJ = n;
            this.zzbNC = zzh2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onFailure(@NonNull Exception exception) {
            Object object = this.zzrJ;
            synchronized (object) {
                ++this.zzbNL;
                this.zzbNH = exception;
                this.zzTJ();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onSuccess(Object object) {
            Object object2 = this.zzrJ;
            synchronized (object2) {
                ++this.zzbNK;
                this.zzTJ();
            }
        }

        private void zzTJ() {
            if (this.zzbNK + this.zzbNL == this.zzbNJ) {
                if (this.zzbNH == null) {
                    this.zzbNC.setResult(null);
                } else {
                    int n = this.zzbNL;
                    int n2 = this.zzbNJ;
                    this.zzbNC.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.zzbNH));
                }
            }
        }
    }

    private static final class zza
    implements zzb {
        private final CountDownLatch zztj = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public void onSuccess(Object object) {
            this.zztj.countDown();
        }

        @Override
        public void onFailure(@NonNull Exception exception) {
            this.zztj.countDown();
        }

        public void await() throws InterruptedException {
            this.zztj.await();
        }

        public boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zztj.await(l, timeUnit);
        }
    }

    static interface zzb
    extends OnFailureListener,
    OnSuccessListener<Object> {
    }
}

