/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.iid;

import android.os.Build;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Message;
import android.os.Messenger;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import com.google.android.gms.common.internal.ReflectedParcelable;
import com.google.android.gms.iid.zzb;
import com.google.android.gms.iid.zzc;
import com.google.android.gms.iid.zzd;

public class MessengerCompat
implements ReflectedParcelable {
    private Messenger zzhtu;
    private zzb zzhtv;
    public static final Parcelable.Creator<MessengerCompat> CREATOR = new zzd();

    public MessengerCompat(IBinder iBinder) {
        IInterface iInterface;
        if (Build.VERSION.SDK_INT >= 21) {
            this.zzhtu = new Messenger(iBinder);
            return;
        }
        IBinder iBinder2 = iBinder;
        this.zzhtv = iBinder2 == null ? null : ((iInterface = iBinder2.queryLocalInterface("com.google.android.gms.iid.IMessengerCompat")) instanceof zzb ? (zzb)iInterface : new zzc(iBinder2));
    }

    public final void send(Message message) throws RemoteException {
        if (this.zzhtu != null) {
            this.zzhtu.send(message);
            return;
        }
        this.zzhtv.send(message);
    }

    private final IBinder getBinder() {
        if (this.zzhtu != null) {
            return this.zzhtu.getBinder();
        }
        return this.zzhtv.asBinder();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        try {
            return this.getBinder().equals(((MessengerCompat)object).getBinder());
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public int hashCode() {
        return this.getBinder().hashCode();
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel parcel, int n) {
        if (this.zzhtu != null) {
            parcel.writeStrongBinder(this.zzhtu.getBinder());
            return;
        }
        parcel.writeStrongBinder(this.zzhtv.asBinder());
    }
}

