/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import android.support.annotation.NonNull;
import com.google.android.gms.common.internal.zzbq;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.OnSuccessListener;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzp;
import com.google.android.gms.tasks.zzq;
import com.google.android.gms.tasks.zzr;
import com.google.android.gms.tasks.zzs;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    public static <TResult> Task<TResult> forResult(TResult TResult) {
        zzp<TResult> zzp2 = new zzp<TResult>();
        zzp2.setResult(TResult);
        return zzp2;
    }

    public static <TResult> Task<TResult> forException(@NonNull Exception exception) {
        zzp zzp2 = new zzp();
        zzp2.setException(exception);
        return zzp2;
    }

    public static <TResult> Task<TResult> call(@NonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    public static <TResult> Task<TResult> call(@NonNull Executor executor, @NonNull Callable<TResult> callable) {
        zzbq.checkNotNull((Object)executor, (Object)"Executor must not be null");
        zzbq.checkNotNull(callable, (Object)"Callback must not be null");
        zzp zzp2 = new zzp();
        executor.execute(new zzq(zzp2, callable));
        return zzp2;
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        zzbq.zzgw((String)"Must not be called on the main application thread");
        zzbq.checkNotNull(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zzc(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        zza2.await();
        return Tasks.zzc(task);
    }

    public static <TResult> TResult await(@NonNull Task<TResult> task, long l, @NonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        zzbq.zzgw((String)"Must not be called on the main application thread");
        zzbq.checkNotNull(task, (Object)"Task must not be null");
        zzbq.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (task.isComplete()) {
            return Tasks.zzc(task);
        }
        zza zza2 = new zza(null);
        Tasks.zza(task, zza2);
        if (!zza2.await(l, timeUnit)) {
            throw new TimeoutException("Timed out waiting for Task");
        }
        return Tasks.zzc(task);
    }

    public static Task<Void> whenAll(Collection<? extends Task<?>> collection) {
        if (collection.isEmpty()) {
            return Tasks.forResult(null);
        }
        Object object = collection.iterator();
        while (object.hasNext()) {
            if (object.next() != null) continue;
            throw new NullPointerException("null tasks are not accepted");
        }
        object = new zzp();
        zzc zzc2 = new zzc(collection.size(), (zzp<Void>)object);
        Iterator<Task<?>> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Tasks.zza(iterator.next(), zzc2);
        }
        return object;
    }

    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Collection<? extends Task<?>> collection) {
        return Tasks.whenAll(collection).continueWith(new zzr(collection));
    }

    public static <TResult> Task<List<TResult>> whenAllSuccess(Task<?> ... taskArray) {
        return Tasks.whenAllSuccess(Arrays.asList(taskArray));
    }

    public static Task<List<Task<?>>> whenAllComplete(Collection<? extends Task<?>> collection) {
        return Tasks.whenAll(collection).continueWith(new zzs(collection));
    }

    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... taskArray) {
        return Tasks.whenAllComplete(Arrays.asList(taskArray));
    }

    private static <TResult> TResult zzc(Task<TResult> task) throws ExecutionException {
        if (task.isSuccessful()) {
            return task.getResult();
        }
        throw new ExecutionException(task.getException());
    }

    private static void zza(Task<?> task, zzb zzb2) {
        task.addOnSuccessListener(TaskExecutors.zzlem, zzb2);
        task.addOnFailureListener(TaskExecutors.zzlem, (OnFailureListener)zzb2);
    }

    private Tasks() {
    }

    static final class zzc
    implements zzb {
        private final Object mLock = new Object();
        private final int zzlet;
        private final zzp<Void> zzlel;
        private int zzleu;
        private int zzlev;
        private Exception zzleq;

        public zzc(int n, zzp<Void> zzp2) {
            this.zzlet = n;
            this.zzlel = zzp2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onFailure(@NonNull Exception exception) {
            Object object = this.mLock;
            synchronized (object) {
                ++this.zzlev;
                this.zzleq = exception;
                this.zzblg();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public final void onSuccess(Object object) {
            Object object2 = this.mLock;
            synchronized (object2) {
                ++this.zzleu;
                this.zzblg();
                return;
            }
        }

        private final void zzblg() {
            if (this.zzleu + this.zzlev == this.zzlet) {
                if (this.zzleq == null) {
                    this.zzlel.setResult(null);
                    return;
                }
                int n = this.zzlev;
                int n2 = this.zzlet;
                this.zzlel.setException(new ExecutionException(new StringBuilder(54).append(n).append(" out of ").append(n2).append(" underlying tasks failed").toString(), this.zzleq));
            }
        }
    }

    static final class zza
    implements zzb {
        private final CountDownLatch zzapc = new CountDownLatch(1);

        private zza() {
        }

        @Override
        public final void onSuccess(Object object) {
            this.zzapc.countDown();
        }

        @Override
        public final void onFailure(@NonNull Exception exception) {
            this.zzapc.countDown();
        }

        public final void await() throws InterruptedException {
            this.zzapc.await();
        }

        public final boolean await(long l, TimeUnit timeUnit) throws InterruptedException {
            return this.zzapc.await(l, timeUnit);
        }

        /* synthetic */ zza(zzq zzq2) {
            this();
        }
    }

    static interface zzb
    extends OnFailureListener,
    OnSuccessListener<Object> {
    }
}

