/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.tasks;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RecentlyNonNull;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskExecutors;
import com.google.android.gms.tasks.zzaa;
import com.google.android.gms.tasks.zzab;
import com.google.android.gms.tasks.zzac;
import com.google.android.gms.tasks.zzw;
import com.google.android.gms.tasks.zzx;
import com.google.android.gms.tasks.zzy;
import com.google.android.gms.tasks.zzz;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public final class Tasks {
    @NonNull
    public static <TResult> Task<TResult> forResult(@RecentlyNonNull TResult TResult) {
        zzw<TResult> zzw2 = new zzw<TResult>();
        zzw2.zza(TResult);
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forException(@RecentlyNonNull Exception exception) {
        zzw zzw2 = new zzw();
        zzw2.zzc(exception);
        return zzw2;
    }

    @NonNull
    public static <TResult> Task<TResult> forCanceled() {
        zzw zzw2 = new zzw();
        zzw2.zze();
        return zzw2;
    }

    @Deprecated
    @NonNull
    public static <TResult> Task<TResult> call(@RecentlyNonNull Callable<TResult> callable) {
        return Tasks.call(TaskExecutors.MAIN_THREAD, callable);
    }

    @Deprecated
    @NonNull
    public static <TResult> Task<TResult> call(@RecentlyNonNull Executor executor, @RecentlyNonNull Callable<TResult> callable) {
        Preconditions.checkNotNull((Object)executor, (Object)"Executor must not be null");
        Preconditions.checkNotNull(callable, (Object)"Callback must not be null");
        zzw zzw2 = new zzw();
        zzx zzx2 = new zzx(zzw2, callable);
        executor.execute(zzx2);
        return zzw2;
    }

    @RecentlyNonNull
    public static <TResult> TResult await(@RecentlyNonNull Task<TResult> task) throws ExecutionException, InterruptedException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(task, (Object)"Task must not be null");
        if (task.isComplete()) {
            return Tasks.zza(task);
        }
        zzaa zzaa2 = new zzaa(null);
        Tasks.zzb(task, zzaa2);
        zzaa2.zza();
        return Tasks.zza(task);
    }

    @RecentlyNonNull
    public static <TResult> TResult await(@RecentlyNonNull Task<TResult> object, long l, @RecentlyNonNull TimeUnit timeUnit) throws ExecutionException, InterruptedException, TimeoutException {
        Preconditions.checkNotMainThread();
        Preconditions.checkNotNull(object, (Object)"Task must not be null");
        Preconditions.checkNotNull((Object)((Object)timeUnit), (Object)"TimeUnit must not be null");
        if (((Task)object).isComplete()) {
            return Tasks.zza(object);
        }
        zzaa zzaa2 = new zzaa(null);
        Tasks.zzb(object, zzaa2);
        if (!zzaa2.zzb(l, timeUnit)) {
            object = new TimeoutException("Timed out waiting for Task");
            throw object;
        }
        return Tasks.zza(object);
    }

    @NonNull
    public static Task<Void> whenAll(@Nullable Collection<? extends Task<?>> iterator) {
        if (iterator == null || iterator.isEmpty()) {
            return Tasks.forResult(null);
        }
        zzw<Void> zzw2 = iterator.iterator();
        while (zzw2.hasNext()) {
            if (zzw2.next() != null) continue;
            iterator = new Iterator("null tasks are not accepted");
            throw iterator;
        }
        zzw2 = new zzw<Void>();
        zzac zzac2 = new zzac(iterator.size(), zzw2);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Tasks.zzb((Task)iterator.next(), zzac2);
        }
        return zzw2;
    }

    @NonNull
    public static Task<Void> whenAll(Task<?> ... taskArray) {
        if (taskArray == null || taskArray.length == 0) {
            return Tasks.forResult(null);
        }
        return Tasks.whenAll(Arrays.asList(taskArray));
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(@Nullable Collection<? extends Task> collection) {
        if (collection == null || collection.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        Task<Void> task = Tasks.whenAll(collection);
        zzy zzy2 = new zzy(collection);
        return task.continueWith(TaskExecutors.MAIN_THREAD, zzy2);
    }

    @NonNull
    public static <TResult> Task<List<TResult>> whenAllSuccess(Task ... taskArray) {
        if (taskArray == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllSuccess(Arrays.asList(taskArray));
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(@Nullable Collection<? extends Task<?>> collection) {
        if (collection == null || collection.isEmpty()) {
            return Tasks.forResult(Collections.emptyList());
        }
        Task<Void> task = Tasks.whenAll(collection);
        zzz zzz2 = new zzz(collection);
        return task.continueWithTask(TaskExecutors.MAIN_THREAD, zzz2);
    }

    @NonNull
    public static Task<List<Task<?>>> whenAllComplete(Task<?> ... taskArray) {
        if (taskArray == null || taskArray.length == 0) {
            return Tasks.forResult(Collections.emptyList());
        }
        return Tasks.whenAllComplete(Arrays.asList(taskArray));
    }

    private Tasks() {
    }

    /*
     * Enabled aggressive block sorting
     */
    private static <TResult> TResult zza(@NonNull Task<TResult> object) throws ExecutionException {
        if (((Task)object).isSuccessful()) {
            return ((Task)object).getResult();
        }
        if (!((Task)object).isCanceled()) {
            ExecutionException executionException = new ExecutionException(((Task)object).getException());
            throw executionException;
        }
        object = new CancellationException("Task is already canceled");
        throw object;
    }

    private static <T> void zzb(Task<T> task, zzab<? super T> zzab2) {
        task.addOnSuccessListener(TaskExecutors.zza, zzab2);
        task.addOnFailureListener(TaskExecutors.zza, zzab2);
        task.addOnCanceledListener(TaskExecutors.zza, zzab2);
    }
}

