/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzbMz;
    private Tracker<T> zzbMO;
    private int zzbMP = 3;
    private boolean zzbMQ = false;
    private int zzbMR;
    private int zzbMS = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzbMz = detector;
        this.zzbMO = tracker;
    }

    @Override
    public void release() {
        this.zzbMO.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzbMS == this.zzbMP) {
                this.zzbMO.onDone();
                this.zzbMQ = false;
            } else {
                this.zzbMO.onMissing(detections);
            }
            ++this.zzbMS;
            return;
        }
        this.zzbMS = 0;
        if (this.zzbMQ) {
            Object object2 = sparseArray.get(this.zzbMR);
            if (object2 != null) {
                this.zzbMO.onUpdate(detections, object2);
                return;
            }
            this.zzbMO.onDone();
            this.zzbMQ = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzbMQ = true;
        this.zzbMR = n;
        this.zzbMz.setFocus(this.zzbMR);
        this.zzbMO.onNewItem(this.zzbMR, object);
        this.zzbMO.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected final void zzbK(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzbMP = n;
    }
}

