/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;

public abstract class FocusingProcessor<T>
implements Detector.Processor<T> {
    private Detector<T> zzbMB;
    private Tracker<T> zzbMQ;
    private int zzbMR = 3;
    private boolean zzbMS = false;
    private int zzbMT;
    private int zzbMU = 0;

    public FocusingProcessor(Detector<T> detector, Tracker<T> tracker) {
        this.zzbMB = detector;
        this.zzbMQ = tracker;
    }

    @Override
    public void release() {
        this.zzbMQ.onDone();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        int n;
        Object object;
        SparseArray<T> sparseArray = detections.getDetectedItems();
        if (sparseArray.size() == 0) {
            if (this.zzbMU == this.zzbMR) {
                this.zzbMQ.onDone();
                this.zzbMS = false;
            } else {
                this.zzbMQ.onMissing(detections);
            }
            ++this.zzbMU;
            return;
        }
        this.zzbMU = 0;
        if (this.zzbMS) {
            Object object2 = sparseArray.get(this.zzbMT);
            if (object2 != null) {
                this.zzbMQ.onUpdate(detections, object2);
                return;
            }
            this.zzbMQ.onDone();
            this.zzbMS = false;
        }
        if ((object = sparseArray.get(n = this.selectFocus(detections))) == null) {
            Log.w((String)"FocusingProcessor", (String)new StringBuilder(35).append("Invalid focus selected: ").append(n).toString());
            return;
        }
        this.zzbMS = true;
        this.zzbMT = n;
        this.zzbMB.setFocus(this.zzbMT);
        this.zzbMQ.onNewItem(this.zzbMT, object);
        this.zzbMQ.onUpdate(detections, object);
    }

    public abstract int selectFocus(Detector.Detections<T> var1);

    protected final void zzbK(int n) {
        if (n < 0) {
            throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
        }
        this.zzbMR = n;
    }
}

