/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private final Object zzkvt = new Object();
    private Processor<T> zzkvu;

    public Detector() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzkvt;
        synchronized (object) {
            if (this.zzkvu != null) {
                this.zzkvu.release();
                this.zzkvu = null;
            }
            return;
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Detections<T> detections;
        Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
        metadata.zzbjr();
        SparseArray<T> sparseArray = this.detect(frame);
        boolean bl = this.isOperational();
        Detections<T> detections2 = detections = new Detections<T>(sparseArray, metadata, bl);
        Detector detector = this;
        Object object = detector.zzkvt;
        synchronized (object) {
            if (detector.zzkvu == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            detector.zzkvu.receiveDetections(detections2);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setProcessor(Processor<T> processor) {
        Object object = this.zzkvt;
        synchronized (object) {
            if (this.zzkvu != null) {
                this.zzkvu.release();
            }
            this.zzkvu = processor;
            return;
        }
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private final SparseArray<T> zzkvv;
        private final Frame.Metadata zzkvw;
        private final boolean zzkvx;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzkvv = sparseArray;
            this.zzkvw = metadata;
            this.zzkvx = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzkvv;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzkvw;
        }

        public boolean detectorIsOperational() {
            return this.zzkvx;
        }
    }
}

