/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzef;
import com.google.android.gms.internal.vision.zzga;
import com.google.android.gms.internal.vision.zzge;
import com.google.android.gms.internal.vision.zzhr;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzfv
extends zzef<Float>
implements zzge<Float>,
zzhr,
RandomAccess {
    private static final zzfv zzwf = new zzfv();
    private float[] zzwg;
    private int size;

    zzfv() {
        this(new float[10], 0);
    }

    private zzfv(float[] fArray, int n) {
        this.zzwg = fArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzcj();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzwg, n2, this.zzwg, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzfv)) {
            return super.equals(object);
        }
        zzfv zzfv2 = (zzfv)object;
        if (this.size != zzfv2.size) {
            return false;
        }
        float[] fArray = zzfv2.zzwg;
        for (int i = 0; i < this.size; ++i) {
            if (Float.floatToIntBits(this.zzwg[i]) == Float.floatToIntBits(fArray[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + Float.floatToIntBits(this.zzwg[i]);
        }
        return n;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzh(float f) {
        this.zzc(this.size, f);
    }

    private final void zzc(int n, float f) {
        this.zzcj();
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
        if (this.size < this.zzwg.length) {
            System.arraycopy(this.zzwg, n, this.zzwg, n + 1, this.size - n);
        } else {
            float[] fArray = new float[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzwg, 0, fArray, 0, n);
            System.arraycopy(this.zzwg, n, fArray, n + 1, this.size - n);
            this.zzwg = fArray;
        }
        this.zzwg[n] = f;
        ++this.size;
        ++this.modCount;
    }

    @Override
    public final boolean addAll(Collection<? extends Float> collection) {
        this.zzcj();
        zzga.checkNotNull(collection);
        if (!(collection instanceof zzfv)) {
            return super.addAll(collection);
        }
        zzfv zzfv2 = (zzfv)collection;
        if (zzfv2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzfv2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzfv2.size;
        if (n > this.zzwg.length) {
            this.zzwg = Arrays.copyOf(this.zzwg, n);
        }
        System.arraycopy(zzfv2.zzwg, 0, this.zzwg, this.size, zzfv2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzcj();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(Float.valueOf(this.zzwg[i]))) continue;
            System.arraycopy(this.zzwg, i + 1, this.zzwg, i, this.size - i);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Float f = (Float)object;
        float f2 = f.floatValue();
        zzfv zzfv2 = this;
        zzfv2.zzcj();
        zzfv2.zzaf(n);
        float f3 = zzfv2.zzwg[n];
        zzfv2.zzwg[n] = f2;
        return Float.valueOf(f3);
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzfv zzfv2 = this;
        zzfv2.zzcj();
        zzfv2.zzaf(n);
        float f = zzfv2.zzwg[n];
        if (n < zzfv2.size - 1) {
            System.arraycopy(zzfv2.zzwg, n + 1, zzfv2.zzwg, n, zzfv2.size - n);
        }
        --zzfv2.size;
        ++zzfv2.modCount;
        return Float.valueOf(f);
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Float f = (Float)object;
        this.zzc(n, f.floatValue());
    }

    @Override
    public final /* synthetic */ zzge zzah(int n) {
        int n2 = n;
        zzfv zzfv2 = this;
        if (n2 < zzfv2.size) {
            throw new IllegalArgumentException();
        }
        return new zzfv(Arrays.copyOf(zzfv2.zzwg, n2), zzfv2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        zzfv zzfv2 = this;
        zzfv2.zzaf(n);
        return Float.valueOf(zzfv2.zzwg[n]);
    }

    static {
        zzwf.zzci();
    }
}

