/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzex;
import com.google.android.gms.internal.vision.zzgt;
import com.google.android.gms.internal.vision.zzgz;
import com.google.android.gms.internal.vision.zzio;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhq
extends zzex<Long>
implements zzgz<Long>,
zzio,
RandomAccess {
    private static final zzhq zzyj = new zzhq(new long[0], 0);
    private long[] zzyk;
    private int size;

    zzhq() {
        this(new long[10], 0);
    }

    private zzhq(long[] lArray, int n) {
        this.zzyk = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdq();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyk, n2, this.zzyk, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhq)) {
            return super.equals(object);
        }
        zzhq zzhq2 = (zzhq)object;
        if (this.size != zzhq2.size) {
            return false;
        }
        long[] lArray = zzhq2.zzyk;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyk[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzgt.zzab(this.zzyk[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzae(n);
        return this.zzyk[n];
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzac(long l) {
        this.zzdq();
        if (this.size == this.zzyk.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyk, 0, lArray, 0, this.size);
            this.zzyk = lArray;
        }
        this.zzyk[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzdq();
        zzgt.checkNotNull(collection);
        if (!(collection instanceof zzhq)) {
            return super.addAll(collection);
        }
        zzhq zzhq2 = (zzhq)collection;
        if (zzhq2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhq2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhq2.size;
        if (n > this.zzyk.length) {
            this.zzyk = Arrays.copyOf(this.zzyk, n);
        }
        System.arraycopy(zzhq2.zzyk, 0, this.zzyk, this.size, zzhq2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdq();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyk[i])) continue;
            System.arraycopy(this.zzyk, i + 1, this.zzyk, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzae(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzaf(n));
        }
    }

    private final String zzaf(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhq zzhq2 = this;
        zzhq2.zzdq();
        zzhq2.zzae(n);
        long l3 = zzhq2.zzyk[n];
        zzhq2.zzyk[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhq zzhq2 = this;
        zzhq2.zzdq();
        zzhq2.zzae(n);
        long l = zzhq2.zzyk[n];
        if (n < zzhq2.size - 1) {
            System.arraycopy(zzhq2.zzyk, n + 1, zzhq2.zzyk, n, zzhq2.size - n - 1);
        }
        --zzhq2.size;
        ++zzhq2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhq zzhq2 = this;
        zzhq2.zzdq();
        if (n < 0 || n > zzhq2.size) {
            throw new IndexOutOfBoundsException(zzhq2.zzaf(n));
        }
        if (zzhq2.size < zzhq2.zzyk.length) {
            System.arraycopy(zzhq2.zzyk, n, zzhq2.zzyk, n + 1, zzhq2.size - n);
        } else {
            long[] lArray = new long[zzhq2.size * 3 / 2 + 1];
            System.arraycopy(zzhq2.zzyk, 0, lArray, 0, n);
            System.arraycopy(zzhq2.zzyk, n, lArray, n + 1, zzhq2.size - n);
            zzhq2.zzyk = lArray;
        }
        zzhq2.zzyk[n] = l2;
        ++zzhq2.size;
        ++zzhq2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzac(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzgz zzag(int n) {
        int n2 = n;
        zzhq zzhq2 = this;
        if (n2 < zzhq2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhq(Arrays.copyOf(zzhq2.zzyk, n2), zzhq2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzyj.zzdp();
    }
}

