/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import android.content.ContentResolver;
import android.database.ContentObserver;
import android.database.Cursor;
import android.database.sqlite.SQLiteException;
import android.net.Uri;
import android.os.StrictMode;
import android.util.Log;
import androidx.annotation.GuardedBy;
import androidx.collection.ArrayMap;
import com.google.android.gms.internal.vision.zzau;
import com.google.android.gms.internal.vision.zzaw;
import com.google.android.gms.internal.vision.zzax;
import com.google.android.gms.internal.vision.zzay;
import com.google.android.gms.internal.vision.zzaz;
import com.google.android.gms.internal.vision.zzbj;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class zzav
implements zzaz {
    @GuardedBy(value="ConfigurationContentLoader.class")
    private static final Map<Uri, zzav> zzfr = new ArrayMap();
    private final ContentResolver zzfs;
    private final Uri uri;
    private final ContentObserver zzft = new zzax(this, null);
    private final Object zzfu = new Object();
    private volatile Map<String, String> zzfv;
    @GuardedBy(value="this")
    private final List<zzaw> zzfw = new ArrayList<zzaw>();
    private static final String[] zzfx = new String[]{"key", "value"};

    private zzav(ContentResolver contentResolver, Uri uri) {
        this.zzfs = contentResolver;
        this.uri = uri;
        contentResolver.registerContentObserver(uri, false, this.zzft);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static zzav zza(ContentResolver contentResolver, Uri uri) {
        Class<zzav> clazz = zzav.class;
        synchronized (zzav.class) {
            zzav zzav2 = zzfr.get(uri);
            if (zzav2 == null) {
                try {
                    zzav2 = new zzav(contentResolver, uri);
                    zzfr.put(uri, zzav2);
                }
                catch (SecurityException securityException) {}
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return zzav2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Map<String, String> zzv() {
        Map<String, String> map = this.zzfv;
        if (map == null) {
            Object object = this.zzfu;
            synchronized (object) {
                map = this.zzfv;
                if (map == null) {
                    this.zzfv = map = this.zzx();
                }
            }
        }
        if (map != null) {
            return map;
        }
        return Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void zzw() {
        zzav zzav2;
        Object object = this.zzfu;
        synchronized (object) {
            this.zzfv = null;
            zzbj.zzac();
        }
        zzav zzav3 = zzav2 = this;
        synchronized (zzav2) {
            Iterator<zzaw> iterator = zzav2.zzfw.iterator();
            while (iterator.hasNext()) {
                iterator.next().zzaa();
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    private final Map<String, String> zzx() {
        StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
        try {
            Map map = (Map)zzay.zza(new zzau(this));
            return map;
        }
        catch (SQLiteException | IllegalStateException | SecurityException throwable) {
            Log.e((String)"ConfigurationContentLoader", (String)"PhenotypeFlag unable to load ContentProvider, using default values");
            return null;
        }
        finally {
            StrictMode.setThreadPolicy((StrictMode.ThreadPolicy)threadPolicy);
        }
    }

    static synchronized void zzy() {
        for (zzav zzav2 : zzfr.values()) {
            zzav2.zzfs.unregisterContentObserver(zzav2.zzft);
        }
        zzfr.clear();
    }

    @Override
    public final /* synthetic */ Object zzb(String string) {
        String string2 = string;
        return this.zzv().get(string2);
    }

    final /* synthetic */ Map zzz() {
        Cursor cursor = this.zzfs.query(this.uri, zzfx, null, null, null);
        if (cursor == null) {
            return Collections.emptyMap();
        }
        try {
            Object object;
            int n = cursor.getCount();
            if (n == 0) {
                Map map = Collections.emptyMap();
                return map;
            }
            Object object2 = object = n <= 256 ? new ArrayMap(n) : new HashMap(n, 1.0f);
            while (cursor.moveToNext()) {
                object.put(cursor.getString(0), cursor.getString(1));
            }
            Object object3 = object;
            return object3;
        }
        finally {
            cursor.close();
        }
    }
}

