/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal.vision;

import com.google.android.gms.internal.vision.zzfc;
import com.google.android.gms.internal.vision.zzgy;
import com.google.android.gms.internal.vision.zzhe;
import com.google.android.gms.internal.vision.zzit;
import java.util.Arrays;
import java.util.Collection;
import java.util.RandomAccess;

final class zzhv
extends zzfc<Long>
implements zzhe<Long>,
zzit,
RandomAccess {
    private static final zzhv zzyy = new zzhv(new long[0], 0);
    private long[] zzyz;
    private int size;

    zzhv() {
        this(new long[10], 0);
    }

    private zzhv(long[] lArray, int n) {
        this.zzyz = lArray;
        this.size = n;
    }

    @Override
    protected final void removeRange(int n, int n2) {
        this.zzdr();
        if (n2 < n) {
            throw new IndexOutOfBoundsException("toIndex < fromIndex");
        }
        System.arraycopy(this.zzyz, n2, this.zzyz, n, this.size - n2);
        this.size -= n2 - n;
        ++this.modCount;
    }

    @Override
    public final boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof zzhv)) {
            return super.equals(object);
        }
        zzhv zzhv2 = (zzhv)object;
        if (this.size != zzhv2.size) {
            return false;
        }
        long[] lArray = zzhv2.zzyz;
        for (int i = 0; i < this.size; ++i) {
            if (this.zzyz[i] == lArray[i]) continue;
            return false;
        }
        return true;
    }

    @Override
    public final int hashCode() {
        int n = 1;
        for (int i = 0; i < this.size; ++i) {
            n = n * 31 + zzgy.zzab(this.zzyz[i]);
        }
        return n;
    }

    public final long getLong(int n) {
        this.zzaf(n);
        return this.zzyz[n];
    }

    @Override
    public final int indexOf(Object object) {
        if (!(object instanceof Long)) {
            return -1;
        }
        long l = (Long)object;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            if (this.zzyz[i] != l) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public final int size() {
        return this.size;
    }

    public final void zzac(long l) {
        this.zzdr();
        if (this.size == this.zzyz.length) {
            long[] lArray = new long[this.size * 3 / 2 + 1];
            System.arraycopy(this.zzyz, 0, lArray, 0, this.size);
            this.zzyz = lArray;
        }
        this.zzyz[this.size++] = l;
    }

    @Override
    public final boolean addAll(Collection<? extends Long> collection) {
        this.zzdr();
        zzgy.checkNotNull(collection);
        if (!(collection instanceof zzhv)) {
            return super.addAll(collection);
        }
        zzhv zzhv2 = (zzhv)collection;
        if (zzhv2.size == 0) {
            return false;
        }
        if (Integer.MAX_VALUE - this.size < zzhv2.size) {
            throw new OutOfMemoryError();
        }
        int n = this.size + zzhv2.size;
        if (n > this.zzyz.length) {
            this.zzyz = Arrays.copyOf(this.zzyz, n);
        }
        System.arraycopy(zzhv2.zzyz, 0, this.zzyz, this.size, zzhv2.size);
        this.size = n;
        ++this.modCount;
        return true;
    }

    @Override
    public final boolean remove(Object object) {
        this.zzdr();
        for (int i = 0; i < this.size; ++i) {
            if (!object.equals(this.zzyz[i])) continue;
            System.arraycopy(this.zzyz, i + 1, this.zzyz, i, this.size - i - 1);
            --this.size;
            ++this.modCount;
            return true;
        }
        return false;
    }

    private final void zzaf(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException(this.zzag(n));
        }
    }

    private final String zzag(int n) {
        int n2 = this.size;
        return new StringBuilder(35).append("Index:").append(n).append(", Size:").append(n2).toString();
    }

    @Override
    public final /* synthetic */ Object set(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhv zzhv2 = this;
        zzhv2.zzdr();
        zzhv2.zzaf(n);
        long l3 = zzhv2.zzyz[n];
        zzhv2.zzyz[n] = l2;
        return l3;
    }

    @Override
    public final /* synthetic */ Object remove(int n) {
        zzhv zzhv2 = this;
        zzhv2.zzdr();
        zzhv2.zzaf(n);
        long l = zzhv2.zzyz[n];
        if (n < zzhv2.size - 1) {
            System.arraycopy(zzhv2.zzyz, n + 1, zzhv2.zzyz, n, zzhv2.size - n - 1);
        }
        --zzhv2.size;
        ++zzhv2.modCount;
        return l;
    }

    @Override
    public final /* synthetic */ void add(int n, Object object) {
        Long l = (Long)object;
        long l2 = l;
        zzhv zzhv2 = this;
        zzhv2.zzdr();
        if (n < 0 || n > zzhv2.size) {
            throw new IndexOutOfBoundsException(zzhv2.zzag(n));
        }
        if (zzhv2.size < zzhv2.zzyz.length) {
            System.arraycopy(zzhv2.zzyz, n, zzhv2.zzyz, n + 1, zzhv2.size - n);
        } else {
            long[] lArray = new long[zzhv2.size * 3 / 2 + 1];
            System.arraycopy(zzhv2.zzyz, 0, lArray, 0, n);
            System.arraycopy(zzhv2.zzyz, n, lArray, n + 1, zzhv2.size - n);
            zzhv2.zzyz = lArray;
        }
        zzhv2.zzyz[n] = l2;
        ++zzhv2.size;
        ++zzhv2.modCount;
    }

    @Override
    public final /* synthetic */ boolean add(Object object) {
        Long l = (Long)object;
        this.zzac(l);
        return true;
    }

    @Override
    public final /* synthetic */ zzhe zzah(int n) {
        int n2 = n;
        zzhv zzhv2 = this;
        if (n2 < zzhv2.size) {
            throw new IllegalArgumentException();
        }
        return new zzhv(Arrays.copyOf(zzhv2.zzyz, n2), zzhv2.size);
    }

    @Override
    public final /* synthetic */ Object get(int n) {
        return this.getLong(n);
    }

    static {
        zzyy.zzdq();
    }
}

