/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.ImageFormat;
import android.graphics.SurfaceTexture;
import android.hardware.Camera;
import android.os.SystemClock;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RequiresPermission;
import com.google.android.gms.common.images.Size;
import com.google.android.gms.common.internal.Preconditions;
import com.google.android.gms.common.util.VisibleForTesting;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;

public class CameraSource {
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_BACK = 0;
    @SuppressLint(value={"InlinedApi"})
    public static final int CAMERA_FACING_FRONT = 1;
    private Context zza;
    private final Object zzb = new Object();
    @Nullable
    @GuardedBy(value="cameraLock")
    private Camera zzc;
    private int zzd = 0;
    private int zze;
    private Size zzf;
    private float zzg = 30.0f;
    private int zzh = 1024;
    private int zzi = 768;
    private boolean zzj = false;
    @Nullable
    private String zzk;
    @Nullable
    private SurfaceTexture zzl;
    @Nullable
    private Thread zzm;
    private zza zzn;
    private final IdentityHashMap<byte[], ByteBuffer> zzo = new IdentityHashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzb;
        synchronized (object) {
            this.stop();
            this.zzn.zza();
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    @RecentlyNonNull
    public CameraSource start() throws IOException {
        Object object = this.zzb;
        synchronized (object) {
            if (this.zzc != null) {
                return this;
            }
            this.zzc = this.zza();
            this.zzl = new SurfaceTexture(100);
            this.zzc.setPreviewTexture(this.zzl);
            this.zzc.startPreview();
            this.zzm = new Thread(this.zzn);
            this.zzm.setName("gms.vision.CameraSource");
            this.zzn.zza(true);
            if (this.zzm != null) {
                this.zzm.start();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermission(value="android.permission.CAMERA")
    @RecentlyNonNull
    public CameraSource start(@RecentlyNonNull SurfaceHolder surfaceHolder) throws IOException {
        Object object = this.zzb;
        synchronized (object) {
            if (this.zzc != null) {
                return this;
            }
            this.zzc = this.zza();
            this.zzc.setPreviewDisplay(surfaceHolder);
            this.zzc.startPreview();
            this.zzm = new Thread(this.zzn);
            this.zzn.zza(true);
            if (this.zzm != null) {
                this.zzm.start();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        Object object = this.zzb;
        synchronized (object) {
            this.zzn.zza(false);
            if (this.zzm != null) {
                try {
                    this.zzm.join();
                }
                catch (InterruptedException interruptedException) {
                    Log.d((String)"CameraSource", (String)"Frame processing thread interrupted on release.");
                }
                this.zzm = null;
            }
            if (this.zzc != null) {
                this.zzc.stopPreview();
                this.zzc.setPreviewCallbackWithBuffer(null);
                try {
                    this.zzc.setPreviewTexture(null);
                    this.zzl = null;
                    this.zzc.setPreviewDisplay(null);
                }
                catch (Exception exception) {
                    String string = String.valueOf(exception);
                    Log.e((String)"CameraSource", (String)new StringBuilder(32 + String.valueOf(string).length()).append("Failed to clear camera preview: ").append(string).toString());
                }
                ((Camera)Preconditions.checkNotNull((Object)this.zzc)).release();
                this.zzc = null;
            }
            this.zzo.clear();
            return;
        }
    }

    @RecentlyNonNull
    public Size getPreviewSize() {
        return this.zzf;
    }

    public int getCameraFacing() {
        return this.zzd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takePicture(@Nullable ShutterCallback shutterCallback, @Nullable PictureCallback pictureCallback) {
        Object object = this.zzb;
        synchronized (object) {
            if (this.zzc != null) {
                zzd zzd2 = new zzd(null);
                zzd2.zza = shutterCallback;
                zzc zzc2 = new zzc(null);
                zzc2.zza = pictureCallback;
                this.zzc.takePicture((Camera.ShutterCallback)zzd2, null, null, (Camera.PictureCallback)zzc2);
            }
            return;
        }
    }

    private CameraSource() {
    }

    @SuppressLint(value={"InlinedApi"})
    private final Camera zza() throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        Object object;
        int n5;
        int n6;
        int n7;
        block25: {
            int n8 = this.zzd;
            Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
            for (n7 = 0; n7 < Camera.getNumberOfCameras(); ++n7) {
                Camera.getCameraInfo((int)n7, (Camera.CameraInfo)cameraInfo);
                if (cameraInfo.facing != n8) continue;
                n6 = n7;
                break block25;
            }
            n6 = n5 = -1;
        }
        if (n6 == -1) {
            throw new IOException("Could not find requested camera.");
        }
        Camera camera = Camera.open((int)n5);
        n7 = this.zzi;
        int n9 = this.zzh;
        Camera.Parameters parameters = camera.getParameters();
        List list = parameters.getSupportedPreviewSizes();
        List list2 = parameters.getSupportedPictureSizes();
        ArrayList<zze> arrayList = new ArrayList<zze>();
        block7: for (Camera.Size size : list) {
            float f = (float)size.width / (float)size.height;
            for (Camera.Size size2 : list2) {
                float f2 = (float)size2.width / (float)size2.height;
                if (!(Math.abs(f - f2) < 0.01f)) continue;
                arrayList.add(new zze(size, size2));
                continue block7;
            }
        }
        if (arrayList.size() == 0) {
            Log.w((String)"CameraSource", (String)"No preview sizes have a corresponding same-aspect-ratio picture size");
            for (Camera.Size size : list) {
                arrayList.add(new zze(size, null));
            }
        }
        Object object2 = arrayList;
        zze zze2 = null;
        int n10 = Integer.MAX_VALUE;
        ArrayList<zze> arrayList2 = object2;
        int n11 = arrayList2.size();
        for (int i = 0; i < n11; ++i) {
            Object e = arrayList2.get(i);
            object = (zze)e;
            Size size = ((zze)object).zza();
            n4 = Math.abs(size.getWidth() - n9) + Math.abs(size.getHeight() - n7);
            if (n4 >= n10) continue;
            zze2 = object;
            n10 = n4;
        }
        zze zze3 = (zze)Preconditions.checkNotNull(zze2);
        if (zze3 == null) {
            throw new IOException("Could not find suitable preview size.");
        }
        Size size = zze3.zzb();
        this.zzf = zze3.zza();
        float f = this.zzg;
        Object object3 = camera;
        n7 = (int)(f * 1000.0f);
        object2 = null;
        int n12 = Integer.MAX_VALUE;
        Camera.CameraInfo cameraInfo = object3.getParameters().getSupportedPreviewFpsRange().iterator();
        while (cameraInfo.hasNext()) {
            object = (int[])cameraInfo.next();
            int n13 = n7 - object[0];
            n4 = n7 - object[1];
            int n14 = Math.abs(n13) + Math.abs(n4);
            if (n14 >= n12) continue;
            object2 = object;
            n12 = n14;
        }
        int[] nArray = (int[])Preconditions.checkNotNull(object2);
        if (nArray == null) {
            throw new IOException("Could not find suitable preview frames per second range.");
        }
        Camera.Parameters parameters2 = camera.getParameters();
        if (size != null) {
            parameters2.setPictureSize(size.getWidth(), size.getHeight());
        }
        parameters2.setPreviewSize(this.zzf.getWidth(), this.zzf.getHeight());
        parameters2.setPreviewFpsRange(nArray[0], nArray[1]);
        parameters2.setPreviewFormat(17);
        n12 = n3 = ((WindowManager)Preconditions.checkNotNull((Object)((WindowManager)this.zza.getSystemService("window")))).getDefaultDisplay().getRotation();
        int n15 = n5;
        Camera.Parameters parameters3 = parameters2;
        Camera camera2 = camera;
        object3 = this;
        n10 = 0;
        switch (n12) {
            case 0: {
                n10 = 0;
                break;
            }
            case 1: {
                n10 = 90;
                break;
            }
            case 2: {
                n10 = 180;
                break;
            }
            case 3: {
                n10 = 270;
                break;
            }
            default: {
                Log.e((String)"CameraSource", (String)new StringBuilder(31).append("Bad rotation value: ").append(n12).toString());
            }
        }
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)n15, (Camera.CameraInfo)cameraInfo);
        if (cameraInfo.facing == 1) {
            n2 = (cameraInfo.orientation + n10) % 360;
            n = (360 - n2) % 360;
        } else {
            n = n2 = (cameraInfo.orientation - n10 + 360) % 360;
        }
        object3.zze = n2 / 90;
        camera2.setDisplayOrientation(n);
        parameters3.setRotation(n2);
        if (this.zzk != null) {
            if (parameters2.getSupportedFocusModes().contains(this.zzk)) {
                parameters2.setFocusMode((String)Preconditions.checkNotNull((Object)this.zzk));
            } else {
                Log.w((String)"CameraSource", (String)String.format("FocusMode %s is not supported on this device.", this.zzk));
                this.zzk = null;
            }
        }
        if (this.zzk == null && this.zzj) {
            if (parameters2.getSupportedFocusModes().contains("continuous-video")) {
                parameters2.setFocusMode("continuous-video");
                this.zzk = "continuous-video";
            } else {
                Log.i((String)"CameraSource", (String)"Camera auto focus is not supported on this device.");
            }
        }
        camera.setParameters(parameters2);
        camera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)new zzb(null));
        camera.addCallbackBuffer(this.zza(this.zzf));
        camera.addCallbackBuffer(this.zza(this.zzf));
        camera.addCallbackBuffer(this.zza(this.zzf));
        camera.addCallbackBuffer(this.zza(this.zzf));
        return camera;
    }

    @SuppressLint(value={"InlinedApi"})
    private final byte[] zza(Size size) {
        int n = ImageFormat.getBitsPerPixel((int)17);
        byte[] byArray = new byte[(int)Math.ceil((double)((long)size.getHeight() * (long)size.getWidth() * (long)n) / 8.0) + 1];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        if (!byteBuffer.hasArray() || byteBuffer.array() != byArray) {
            throw new IllegalStateException("Failed to create valid buffer for camera source.");
        }
        this.zzo.put(byArray, byteBuffer);
        return byArray;
    }

    /* synthetic */ CameraSource(com.google.android.gms.vision.zza zza2) {
        this();
    }

    private final class zza
    implements Runnable {
        @Nullable
        private Detector<?> zza;
        private long zzb = SystemClock.elapsedRealtime();
        private final Object zzc = new Object();
        private boolean zzd = true;
        private long zze;
        private int zzf = 0;
        @Nullable
        private ByteBuffer zzg;

        zza(Detector<?> detector) {
            this.zza = detector;
        }

        @SuppressLint(value={"Assert"})
        final void zza() {
            if (this.zza != null) {
                this.zza.release();
                this.zza = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void zza(boolean bl) {
            Object object = this.zzc;
            synchronized (object) {
                this.zzd = bl;
                this.zzc.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        final void zza(byte[] byArray, Camera camera) {
            Object object = this.zzc;
            synchronized (object) {
                if (this.zzg != null) {
                    camera.addCallbackBuffer(this.zzg.array());
                    this.zzg = null;
                }
                if (!CameraSource.this.zzo.containsKey(byArray)) {
                    Log.d((String)"CameraSource", (String)"Skipping frame. Could not find ByteBuffer associated with the image data from the camera.");
                    return;
                }
                this.zze = SystemClock.elapsedRealtime() - this.zzb;
                ++this.zzf;
                this.zzg = (ByteBuffer)CameraSource.this.zzo.get(byArray);
                this.zzc.notifyAll();
                return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        @SuppressLint(value={"InlinedApi"})
        public final void run() {
            while (true) {
                ByteBuffer byteBuffer;
                Frame frame;
                Object object = this.zzc;
                synchronized (object) {
                    while (this.zzd && this.zzg == null) {
                        try {
                            this.zzc.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            Log.d((String)"CameraSource", (String)"Frame processing loop terminated.", (Throwable)interruptedException);
                            return;
                        }
                    }
                    if (!this.zzd) {
                        return;
                    }
                    frame = new Frame.Builder().setImageData((ByteBuffer)Preconditions.checkNotNull((Object)this.zzg), CameraSource.this.zzf.getWidth(), CameraSource.this.zzf.getHeight(), 17).setId(this.zzf).setTimestampMillis(this.zze).setRotation(CameraSource.this.zze).build();
                    byteBuffer = this.zzg;
                    this.zzg = null;
                }
                try {
                    ((Detector)Preconditions.checkNotNull(this.zza)).receiveFrame(frame);
                    continue;
                }
                catch (Exception exception) {
                    Log.e((String)"CameraSource", (String)"Exception thrown from receiver.", (Throwable)exception);
                    continue;
                }
                finally {
                    ((Camera)Preconditions.checkNotNull((Object)CameraSource.this.zzc)).addCallbackBuffer(((ByteBuffer)Preconditions.checkNotNull((Object)byteBuffer)).array());
                    continue;
                }
                break;
            }
        }
    }

    private final class zzb
    implements Camera.PreviewCallback {
        private zzb() {
        }

        public final void onPreviewFrame(byte[] byArray, Camera camera) {
            CameraSource.this.zzn.zza(byArray, camera);
        }

        /* synthetic */ zzb(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    @VisibleForTesting
    static final class zze {
        private Size zza;
        private Size zzb;

        public zze(Camera.Size size, @Nullable Camera.Size size2) {
            this.zza = new Size(size.width, size.height);
            if (size2 != null) {
                this.zzb = new Size(size2.width, size2.height);
            }
        }

        public final Size zza() {
            return this.zza;
        }

        @Nullable
        public final Size zzb() {
            return this.zzb;
        }
    }

    private final class zzc
    implements Camera.PictureCallback {
        @Nullable
        private PictureCallback zza;

        private zzc() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void onPictureTaken(byte[] byArray, Camera camera) {
            if (this.zza != null) {
                this.zza.onPictureTaken(byArray);
            }
            Object object = CameraSource.this.zzb;
            synchronized (object) {
                if (CameraSource.this.zzc != null) {
                    CameraSource.this.zzc.startPreview();
                }
                return;
            }
        }

        /* synthetic */ zzc(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    private static final class zzd
    implements Camera.ShutterCallback {
        @Nullable
        private ShutterCallback zza;

        private zzd() {
        }

        public final void onShutter() {
            if (this.zza != null) {
                this.zza.onShutter();
            }
        }

        /* synthetic */ zzd(com.google.android.gms.vision.zza zza2) {
            this();
        }
    }

    public static interface PictureCallback {
        public void onPictureTaken(@RecentlyNonNull byte[] var1);
    }

    public static interface ShutterCallback {
        public void onShutter();
    }

    public static class Builder {
        private final Detector<?> zza;
        private CameraSource zzb = new CameraSource(null);

        public Builder(@RecentlyNonNull Context context, @RecentlyNonNull Detector<?> detector) {
            if (context == null) {
                throw new IllegalArgumentException("No context supplied.");
            }
            if (detector == null) {
                throw new IllegalArgumentException("No detector supplied.");
            }
            this.zza = detector;
            this.zzb.zza = context;
        }

        @RecentlyNonNull
        public Builder setRequestedFps(float f) {
            if (f <= 0.0f) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid fps: ").append(f).toString());
            }
            this.zzb.zzg = f;
            return this;
        }

        @RecentlyNonNull
        public Builder setRequestedPreviewSize(int n, int n2) {
            if (n <= 0 || n > 1000000 || n2 <= 0 || n2 > 1000000) {
                throw new IllegalArgumentException(new StringBuilder(45).append("Invalid preview size: ").append(n).append("x").append(n2).toString());
            }
            this.zzb.zzh = n;
            this.zzb.zzi = n2;
            return this;
        }

        @RecentlyNonNull
        public Builder setFacing(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(27).append("Invalid camera: ").append(n).toString());
            }
            this.zzb.zzd = n;
            return this;
        }

        @RecentlyNonNull
        public Builder setAutoFocusEnabled(boolean bl) {
            this.zzb.zzj = bl;
            return this;
        }

        @RecentlyNonNull
        public Builder setFocusMode(@RecentlyNonNull String string) {
            if (!string.equals("continuous-video") && !string.equals("continuous-picture")) {
                Log.w((String)"CameraSource", (String)String.format("FocusMode %s is not supported for now.", string));
                this.zzb.zzk = null;
            } else {
                this.zzb.zzk = string;
            }
            return this;
        }

        @RecentlyNonNull
        public CameraSource build() {
            CameraSource cameraSource = this.zzb;
            cameraSource.getClass();
            this.zzb.zzn = cameraSource.new zza(this.zza);
            return this.zzb;
        }
    }
}

