/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.graphics.Bitmap;
import android.graphics.Color;
import android.media.Image;
import androidx.annotation.RecentlyNonNull;
import androidx.annotation.RecentlyNullable;
import androidx.annotation.RequiresApi;
import com.google.android.gms.common.annotation.KeepForSdk;
import com.google.android.gms.vision.zzb;
import java.nio.ByteBuffer;
import javax.annotation.Nullable;

public class Frame {
    public static final int ROTATION_0 = 0;
    public static final int ROTATION_90 = 1;
    public static final int ROTATION_180 = 2;
    public static final int ROTATION_270 = 3;
    private final Metadata zza = new Metadata();
    @Nullable
    private ByteBuffer zzb = null;
    @Nullable
    @RequiresApi(value=19)
    private zza zzc = null;
    @Nullable
    private Bitmap zzd = null;

    @RecentlyNonNull
    public Metadata getMetadata() {
        return this.zza;
    }

    @RecentlyNullable
    @KeepForSdk
    @RequiresApi(value=19)
    public Image.Plane[] getPlanes() {
        if (this.zzc == null) {
            return null;
        }
        return this.zzc.zza();
    }

    @RecentlyNullable
    public ByteBuffer getGrayscaleImageData() {
        if (this.zzd != null) {
            Frame frame = this;
            if (frame.zzd == null) {
                return null;
            }
            int n = frame.zzd.getWidth();
            int n2 = frame.zzd.getHeight();
            int[] nArray = new int[n * n2];
            frame.zzd.getPixels(nArray, 0, n, 0, 0, n, n2);
            byte[] byArray = new byte[n * n2];
            for (int i = 0; i < nArray.length; ++i) {
                byArray[i] = (byte)((float)Color.red((int)nArray[i]) * 0.299f + (float)Color.green((int)nArray[i]) * 0.587f + (float)Color.blue((int)nArray[i]) * 0.114f);
            }
            return ByteBuffer.wrap(byArray);
        }
        return this.zzb;
    }

    @RecentlyNullable
    public Bitmap getBitmap() {
        return this.zzd;
    }

    private Frame() {
    }

    /* synthetic */ Frame(zzb zzb2) {
        this();
    }

    private static final class zza {
        private final Image.Plane[] zza;

        zza(Image.Plane[] planeArray) {
            this.zza = planeArray;
        }

        final Image.Plane[] zza() {
            return this.zza;
        }
    }

    public static class Metadata {
        private int zza;
        private int zzb;
        private int zzc;
        private long zzd;
        private int zze;
        private int zzf = -1;

        public Metadata() {
        }

        public Metadata(@RecentlyNonNull Metadata metadata) {
            this.zza = metadata.getWidth();
            this.zzb = metadata.getHeight();
            this.zzc = metadata.getId();
            this.zzd = metadata.getTimestampMillis();
            this.zze = metadata.getRotation();
            this.zzf = metadata.getFormat();
        }

        public int getWidth() {
            return this.zza;
        }

        public int getHeight() {
            return this.zzb;
        }

        public int getId() {
            return this.zzc;
        }

        public long getTimestampMillis() {
            return this.zzd;
        }

        public int getRotation() {
            return this.zze;
        }

        public int getFormat() {
            return this.zzf;
        }

        public final void zza() {
            if (this.zze % 2 != 0) {
                int n = this.zza;
                this.zza = this.zzb;
                this.zzb = n;
            }
            this.zze = 0;
        }
    }

    public static class Builder {
        private final Frame zza = new Frame(null);

        @RecentlyNonNull
        public Builder setBitmap(@RecentlyNonNull Bitmap bitmap) {
            int n = bitmap.getWidth();
            int n2 = bitmap.getHeight();
            this.zza.zzd = bitmap;
            Metadata metadata = this.zza.getMetadata();
            metadata.zza = n;
            metadata.zzb = n2;
            return this;
        }

        @KeepForSdk
        @RequiresApi(value=19)
        @RecentlyNonNull
        public Builder setPlanes(@RecentlyNonNull Image.Plane[] planeArray, int n, int n2, int n3) {
            if (planeArray == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (planeArray.length != 3) {
                throw new IllegalArgumentException("Only android.graphics.ImageFormat#YUV_420_888 is supported which should have 3 planes.");
            }
            if (planeArray[0].getBuffer().capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            this.zza.zzc = new zza(planeArray);
            Metadata metadata = this.zza.getMetadata();
            metadata.zza = n;
            metadata.zzb = n2;
            metadata.zzf = n3;
            return this;
        }

        @RecentlyNonNull
        public Builder setImageData(@RecentlyNonNull ByteBuffer byteBuffer, int n, int n2, int n3) {
            if (byteBuffer == null) {
                throw new IllegalArgumentException("Null image data supplied.");
            }
            if (byteBuffer.capacity() < n * n2) {
                throw new IllegalArgumentException("Invalid image data size.");
            }
            switch (n3) {
                case 16: 
                case 17: 
                case 842094169: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(37).append("Unsupported image format: ").append(n3).toString());
                }
            }
            this.zza.zzb = byteBuffer;
            Metadata metadata = this.zza.getMetadata();
            metadata.zza = n;
            metadata.zzb = n2;
            metadata.zzf = n3;
            return this;
        }

        @RecentlyNonNull
        public Builder setId(int n) {
            this.zza.getMetadata().zzc = n;
            return this;
        }

        @RecentlyNonNull
        public Builder setTimestampMillis(long l) {
            this.zza.getMetadata().zzd = l;
            return this;
        }

        @RecentlyNonNull
        public Builder setRotation(int n) {
            this.zza.getMetadata().zze = n;
            return this;
        }

        @RecentlyNonNull
        public Frame build() {
            if (this.zza.zzb == null && this.zza.zzd == null && this.zza.zzc == null) {
                throw new IllegalStateException("Missing image data.  Call either setBitmap or setImageData to specify the image");
            }
            return this.zza;
        }
    }
}

