/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.internal;

import android.content.Context;
import android.graphics.PointF;
import android.os.RemoteException;
import android.util.Log;
import com.google.android.gms.dynamic.zzd;
import com.google.android.gms.dynamic.zze;
import com.google.android.gms.dynamite.DynamiteModule;
import com.google.android.gms.internal.zzbgu;
import com.google.android.gms.internal.zzbgw;
import com.google.android.gms.internal.zzbgy;
import com.google.android.gms.internal.zzbgz;
import com.google.android.gms.internal.zzbha;
import com.google.android.gms.internal.zzbhc;
import com.google.android.gms.internal.zzbhd;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.face.Landmark;
import java.nio.ByteBuffer;

public class zzbgt
extends zzbhc<zzbgy> {
    private final zzbgw zzbNc;

    public zzbgt(Context context, zzbgw zzbgw2) {
        super(context, "FaceNativeHandle");
        this.zzbNc = zzbgw2;
        this.zzSq();
    }

    public Face[] zzb(ByteBuffer byteBuffer, zzbhd zzbhd2) {
        zzbgu[] zzbguArray;
        Face[] faceArray;
        if (!this.isOperational()) {
            return new Face[0];
        }
        try {
            faceArray = zze.zzA((Object)byteBuffer);
            zzbguArray = ((zzbgy)this.zzSq()).zzc((zzd)faceArray, zzbhd2);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return new Face[0];
        }
        faceArray = new Face[zzbguArray.length];
        for (int i = 0; i < zzbguArray.length; ++i) {
            faceArray[i] = this.zza(zzbguArray[i]);
        }
        return faceArray;
    }

    public boolean zznw(int n) {
        if (!this.isOperational()) {
            return false;
        }
        try {
            return ((zzbgy)this.zzSq()).zznw(n);
        }
        catch (RemoteException remoteException) {
            Log.e((String)"FaceNativeHandle", (String)"Could not call native face detector", (Throwable)remoteException);
            return false;
        }
    }

    protected zzbgy zzc(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.zza {
        zzbgz zzbgz2 = zzbgz.zza.zzfj(dynamiteModule.zzdX("com.google.android.gms.vision.face.ChimeraNativeFaceDetectorCreator"));
        zzd zzd2 = zze.zzA((Object)context);
        return zzbgz2.zza(zzd2, this.zzbNc);
    }

    @Override
    protected void zzSn() throws RemoteException {
        ((zzbgy)this.zzSq()).zzSo();
    }

    private Face zza(zzbgu zzbgu2) {
        return new Face(zzbgu2.id, new PointF(zzbgu2.centerX, zzbgu2.centerY), zzbgu2.width, zzbgu2.height, zzbgu2.zzbNd, zzbgu2.zzbNe, this.zzb(zzbgu2), zzbgu2.zzbNg, zzbgu2.zzbNh, zzbgu2.zzbNi);
    }

    private Landmark[] zzb(zzbgu zzbgu2) {
        Landmark[] landmarkArray;
        zzbha[] zzbhaArray = zzbgu2.zzbNf;
        if (zzbhaArray == null) {
            landmarkArray = new Landmark[]{};
        } else {
            landmarkArray = new Landmark[zzbhaArray.length];
            for (int i = 0; i < zzbhaArray.length; ++i) {
                landmarkArray[i] = this.zza(zzbhaArray[i]);
            }
        }
        return landmarkArray;
    }

    private Landmark zza(zzbha zzbha2) {
        return new Landmark(new PointF(zzbha2.x, zzbha2.y), zzbha2.type);
    }

    @Override
    protected /* synthetic */ Object zzb(DynamiteModule dynamiteModule, Context context) throws RemoteException, DynamiteModule.zza {
        return this.zzc(dynamiteModule, context);
    }
}

