/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbMo = new Object();
    private Processor<T> zzbMp;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbMo;
        synchronized (object) {
            if (this.zzbMp != null) {
                this.zzbMp.release();
                this.zzbMp = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbMo;
        synchronized (object) {
            if (this.zzbMp == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzSm();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbMp.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbMp = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbMq;
        private Frame.Metadata zzbMr;
        private boolean zzbMs;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbMq = sparseArray;
            this.zzbMr = metadata;
            this.zzbMs = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbMq;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbMr;
        }

        public boolean detectorIsOperational() {
            return this.zzbMs;
        }
    }
}

