/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.face;

import android.content.Context;
import android.util.Log;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbgt;
import com.google.android.gms.internal.zzbgw;
import com.google.android.gms.internal.zzbhd;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.face.Face;
import com.google.android.gms.vision.zza;
import java.nio.ByteBuffer;
import java.util.HashSet;

public final class FaceDetector
extends Detector<Face> {
    public static final int NO_LANDMARKS = 0;
    public static final int ALL_LANDMARKS = 1;
    public static final int NO_CLASSIFICATIONS = 0;
    public static final int ALL_CLASSIFICATIONS = 1;
    public static final int FAST_MODE = 0;
    public static final int ACCURATE_MODE = 1;
    private final zza zzbMT = new zza();
    private final zzbgt zzbMU;
    private final Object zzrN = new Object();
    private boolean zzbMV = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void release() {
        super.release();
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.zzbMV) {
                return;
            }
            this.zzbMU.zzSp();
            this.zzbMV = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            Object object = this.zzrN;
            synchronized (object) {
                if (this.zzbMV) {
                    Log.w((String)"FaceDetector", (String)"FaceDetector was not released with FaceDetector.release()");
                    this.release();
                }
            }
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SparseArray<Face> detect(Frame frame) {
        Face[] faceArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        ByteBuffer byteBuffer = frame.getGrayscaleImageData();
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.zzbMV) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            faceArray = this.zzbMU.zzb(byteBuffer, zzbhd.zzc(frame));
        }
        int n = 0;
        HashSet<Integer> hashSet = new HashSet<Integer>();
        SparseArray sparseArray = new SparseArray(faceArray.length);
        for (Face face : faceArray) {
            int n2 = face.getId();
            n = Math.max(n, n2);
            if (hashSet.contains(n2)) {
                n2 = ++n;
            }
            hashSet.add(n2);
            int n3 = this.zzbMT.zzng(n2);
            sparseArray.append(n3, (Object)face);
        }
        return sparseArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean setFocus(int n) {
        int n2 = this.zzbMT.zznh(n);
        Object object = this.zzrN;
        synchronized (object) {
            if (!this.zzbMV) {
                throw new RuntimeException("Cannot use detector after release()");
            }
            return this.zzbMU.zznw(n2);
        }
    }

    @Override
    public boolean isOperational() {
        return this.zzbMU.isOperational();
    }

    private FaceDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private FaceDetector(zzbgt zzbgt2) {
        this.zzbMU = zzbgt2;
    }

    public static class Builder {
        private final Context mContext;
        private int zzbMW = 0;
        private boolean zzbMX = false;
        private int zzbMY = 0;
        private boolean zzbMZ = true;
        private int zzaJi = 0;
        private float zzbNa = -1.0f;

        public Builder(Context context) {
            this.mContext = context;
        }

        public Builder setLandmarkType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(34).append("Invalid landmark type: ").append(n).toString());
            }
            this.zzbMW = n;
            return this;
        }

        public Builder setProminentFaceOnly(boolean bl) {
            this.zzbMX = bl;
            return this;
        }

        public Builder setClassificationType(int n) {
            if (n != 0 && n != 1) {
                throw new IllegalArgumentException(new StringBuilder(40).append("Invalid classification type: ").append(n).toString());
            }
            this.zzbMY = n;
            return this;
        }

        public Builder setTrackingEnabled(boolean bl) {
            this.zzbMZ = bl;
            return this;
        }

        public Builder setMode(int n) {
            switch (n) {
                case 0: 
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException(new StringBuilder(25).append("Invalid mode: ").append(n).toString());
                }
            }
            this.zzaJi = n;
            return this;
        }

        public Builder setMinFaceSize(float f) {
            if (f < 0.0f || f > 1.0f) {
                throw new IllegalArgumentException(new StringBuilder(47).append("Invalid proportional face size: ").append(f).toString());
            }
            this.zzbNa = f;
            return this;
        }

        public FaceDetector build() {
            zzbgw zzbgw2 = new zzbgw();
            zzbgw2.mode = this.zzaJi;
            zzbgw2.zzbNj = this.zzbMW;
            zzbgw2.zzbNk = this.zzbMY;
            zzbgw2.zzbNl = this.zzbMX;
            zzbgw2.zzbNm = this.zzbMZ;
            zzbgw2.zzbNn = this.zzbNa;
            zzbgt zzbgt2 = new zzbgt(this.mContext, zzbgw2);
            return new FaceDetector(zzbgt2);
        }
    }
}

