/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbhg;
import com.google.android.gms.internal.zzbhk;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TextBlock
implements Text {
    private zzbhk[] zzbNu;
    private Point[] cornerPoints;
    private List<Line> zzbNv;
    private String zzbNw;
    private Rect zzbNx;

    TextBlock(SparseArray<zzbhk> sparseArray) {
        this.zzbNu = new zzbhk[sparseArray.size()];
        for (int i = 0; i < this.zzbNu.length; ++i) {
            this.zzbNu[i] = (zzbhk)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzbNw != null) {
            return this.zzbNw;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        for (zzbhk zzbhk2 : this.zzbNu) {
            int n = 0;
            if (hashMap.containsKey(zzbhk2.zzbNw)) {
                n = (Integer)hashMap.get(zzbhk2.zzbNw);
            }
            hashMap.put(zzbhk2.zzbNw, n + 1);
        }
        this.zzbNw = Collections.max(hashMap.entrySet(), new Comparator<Map.Entry<String, Integer>>(this){

            public int zza(Map.Entry<String, Integer> entry, Map.Entry<String, Integer> entry2) {
                return entry.getValue().compareTo(entry2.getValue());
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.zza((Map.Entry)object, (Map.Entry)object2);
            }
        }).getKey();
        if (this.zzbNw == null || this.zzbNw.isEmpty()) {
            this.zzbNw = "und";
        }
        return this.zzbNw;
    }

    @Override
    public String getValue() {
        if (this.zzbNu.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzbNu[0].zzbNF);
        for (int i = 1; i < this.zzbNu.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzbNu[i].zzbNF);
        }
        return stringBuilder.toString();
    }

    void zzSs() {
        if (this.zzbNu.length == 0) {
            this.cornerPoints = new Point[0];
            return;
        }
        int n = Integer.MAX_VALUE;
        int n2 = Integer.MIN_VALUE;
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        for (int i = 0; i < this.zzbNu.length; ++i) {
            Point[] pointArray = TextBlock.zza(this.zzbNu[i].zzbNC, this.zzbNu[0].zzbNC);
            for (int j = 0; j < 4; ++j) {
                Point point = pointArray[j];
                n = Math.min(n, point.x);
                n2 = Math.max(n2, point.x);
                n3 = Math.min(n3, point.y);
                n4 = Math.max(n4, point.y);
            }
        }
        this.cornerPoints = TextBlock.zza(n, n3, n2, n4, this.zzbNu[0].zzbNC);
    }

    private static Point[] zza(int n, int n2, int n3, int n4, zzbhg zzbhg2) {
        int n5 = zzbhg2.left;
        int n6 = zzbhg2.top;
        double d = Math.sin(Math.toRadians(zzbhg2.zzbNA));
        double d2 = Math.cos(Math.toRadians(zzbhg2.zzbNA));
        Point[] pointArray = new Point[]{new Point(n, n2), new Point(n3, n2), new Point(n3, n4), new Point(n, n4)};
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray[i].x * d2 - (double)pointArray[i].y * d);
            int n8 = (int)((double)pointArray[i].x * d + (double)pointArray[i].y * d2);
            pointArray[i].x = n7;
            pointArray[i].y = n8;
            pointArray[i].offset(n5, n6);
        }
        return pointArray;
    }

    private static Point[] zza(zzbhg zzbhg2, zzbhg zzbhg3) {
        int n = -zzbhg3.left;
        int n2 = -zzbhg3.top;
        double d = Math.sin(Math.toRadians(zzbhg3.zzbNA));
        double d2 = Math.cos(Math.toRadians(zzbhg3.zzbNA));
        Point[] pointArray = new Point[4];
        pointArray[0] = new Point(zzbhg2.left, zzbhg2.top);
        pointArray[0].offset(n, n2);
        int n3 = (int)((double)pointArray[0].x * d2 + (double)pointArray[0].y * d);
        int n4 = (int)((double)(-pointArray[0].x) * d + (double)pointArray[0].y * d2);
        pointArray[0].x = n3;
        pointArray[0].y = n4;
        pointArray[1] = new Point(n3 + zzbhg2.width, n4);
        pointArray[2] = new Point(n3 + zzbhg2.width, n4 + zzbhg2.height);
        pointArray[3] = new Point(n3, n4 + zzbhg2.height);
        return pointArray;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            this.zzSs();
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        return this.zzSt();
    }

    List<Line> zzSt() {
        if (this.zzbNu.length == 0) {
            return new ArrayList<Line>(0);
        }
        if (this.zzbNv == null) {
            this.zzbNv = new ArrayList<Line>(this.zzbNu.length);
            for (zzbhk zzbhk2 : this.zzbNu) {
                this.zzbNv.add(new Line(zzbhk2));
            }
        }
        return this.zzbNv;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzbNx == null) {
            this.zzbNx = zza.zza(this);
        }
        return this.zzbNx;
    }
}

