/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbhd;
import com.google.android.gms.internal.zzbhf;
import com.google.android.gms.internal.zzbhk;
import com.google.android.gms.internal.zzbhm;
import com.google.android.gms.internal.zzbhq;
import com.google.android.gms.internal.zzbhr;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzbhq zzbNy;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzbhq zzbhq2) {
        this.zzbNy = zzbhq2;
    }

    @Override
    public SparseArray<TextBlock> detect(Frame frame) {
        return this.zza(frame, new zzbhm(1, new Rect()));
    }

    public SparseArray<TextBlock> zza(Frame frame, zzbhm zzbhm2) {
        Frame.Metadata metadata;
        Bitmap bitmap;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzbhd zzbhd2 = zzbhd.zzc(frame);
        if (frame.getBitmap() != null) {
            bitmap = frame.getBitmap();
        } else {
            metadata = frame.getMetadata();
            bitmap = this.zza(frame.getGrayscaleImageData(), metadata.getFormat(), zzbhd2.width, zzbhd2.height);
        }
        bitmap = zzbhf.zzb(bitmap, zzbhd2);
        if (!zzbhm2.zzbNL.isEmpty()) {
            metadata = this.zza(zzbhm2.zzbNL, frame.getMetadata().getWidth(), frame.getMetadata().getHeight(), zzbhd2);
            zzbhm2.zzbNL.set((Rect)metadata);
        }
        zzbhd2.rotation = 0;
        return this.zza(this.zzbNy.zza(bitmap, zzbhd2, zzbhm2));
    }

    private Bitmap zza(ByteBuffer byteBuffer, int n, int n2, int n3) {
        byte[] byArray;
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[byteBuffer.capacity()];
            byteBuffer.get(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage = new YuvImage(byArray, n, n2, n3, null);
        yuvImage.compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    private Rect zza(Rect rect, int n, int n2, zzbhd zzbhd2) {
        switch (zzbhd2.rotation) {
            case 1: {
                return new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
            }
            case 2: {
                return new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
            }
            case 3: {
                return new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
            }
        }
        return rect;
    }

    private SparseArray<TextBlock> zza(zzbhk[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (zzbhk zzbhk2 : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(zzbhk2.zzbNJ);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(zzbhk2.zzbNJ, (Object)sparseArray3);
            }
            sparseArray3.append(zzbhk2.zzbNK, (Object)zzbhk2);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<zzbhk>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    @Override
    public boolean isOperational() {
        return this.zzbNy.isOperational();
    }

    @Override
    public void release() {
        super.release();
        this.zzbNy.zzSp();
    }

    public static class Builder {
        private Context mContext;
        private zzbhr zzbNz;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbNz = new zzbhr();
        }

        public TextRecognizer build() {
            zzbhq zzbhq2 = new zzbhq(this.mContext, this.zzbNz);
            return new TextRecognizer(zzbhq2);
        }
    }
}

