/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Frame;

public abstract class Detector<T> {
    private Object zzbOn = new Object();
    private Processor<T> zzbOo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        Object object = this.zzbOn;
        synchronized (object) {
            if (this.zzbOo != null) {
                this.zzbOo.release();
                this.zzbOo = null;
            }
        }
    }

    public abstract SparseArray<T> detect(Frame var1);

    public boolean setFocus(int n) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveFrame(Frame frame) {
        Object object = this.zzbOn;
        synchronized (object) {
            if (this.zzbOo == null) {
                throw new IllegalStateException("Detector processor must first be set with setProcessor in order to receive detection results.");
            }
            Frame.Metadata metadata = new Frame.Metadata(frame.getMetadata());
            metadata.zzTN();
            SparseArray<T> sparseArray = this.detect(frame);
            boolean bl = this.isOperational();
            Detections<T> detections = new Detections<T>(sparseArray, metadata, bl);
            this.zzbOo.receiveDetections(detections);
        }
    }

    public void setProcessor(Processor<T> processor) {
        this.zzbOo = processor;
    }

    public boolean isOperational() {
        return true;
    }

    public static interface Processor<T> {
        public void release();

        public void receiveDetections(Detections<T> var1);
    }

    public static class Detections<T> {
        private SparseArray<T> zzbOp;
        private Frame.Metadata zzbOq;
        private boolean zzbOr;

        public Detections(SparseArray<T> sparseArray, Frame.Metadata metadata, boolean bl) {
            this.zzbOp = sparseArray;
            this.zzbOq = metadata;
            this.zzbOr = bl;
        }

        public SparseArray<T> getDetectedItems() {
            return this.zzbOp;
        }

        public Frame.Metadata getFrameMetadata() {
            return this.zzbOq;
        }

        public boolean detectorIsOperational() {
            return this.zzbOr;
        }
    }
}

