/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbjl;
import com.google.android.gms.internal.zzbjn;
import com.google.android.gms.internal.zzbka;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final zzbjn zzbOI;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(zzbjn zzbjn2) {
        this.zzbOI = zzbjn2;
    }

    @Override
    public void release() {
        super.release();
        this.zzbOI.zzTQ();
    }

    @Override
    public SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzbka zzbka2 = zzbka.zzc(frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbOI.zza(frame.getBitmap(), zzbka2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbOI.zza(byteBuffer, zzbka2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        for (Barcode barcode : barcodeArray) {
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    @Override
    public boolean isOperational() {
        return this.zzbOI.isOperational();
    }

    public static class Builder {
        private Context mContext;
        private zzbjl zzbOJ;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbOJ = new zzbjl();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbOJ.zzbOK = n;
            return this;
        }

        public BarcodeDetector build() {
            zzbjn zzbjn2 = new zzbjn(this.mContext, this.zzbOJ);
            return new BarcodeDetector(zzbjn2);
        }
    }
}

