/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision;

import android.util.SparseArray;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Tracker;
import java.util.HashSet;

public class MultiProcessor<T>
implements Detector.Processor<T> {
    private Factory<T> zzbOE;
    private SparseArray<zza> zzbOF = new SparseArray();
    private int zzbOs = 3;

    @Override
    public void release() {
        for (int i = 0; i < this.zzbOF.size(); ++i) {
            Tracker tracker = ((zza)this.zzbOF.valueAt(i)).zzbOr;
            tracker.onDone();
        }
        this.zzbOF.clear();
    }

    @Override
    public void receiveDetections(Detector.Detections<T> detections) {
        this.zza(detections);
        this.zzb(detections);
        this.zzc(detections);
    }

    private MultiProcessor() {
    }

    private void zza(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            if (this.zzbOF.get(n) != null) continue;
            zza zza2 = new zza(this);
            zza2.zzbOr = this.zzbOE.create(object);
            zza2.zzbOr.onNewItem(n, object);
            this.zzbOF.append(n, (Object)zza2);
        }
    }

    private void zzb(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        HashSet<Integer> hashSet = new HashSet<Integer>();
        for (int i = 0; i < this.zzbOF.size(); ++i) {
            int n = this.zzbOF.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            zza zza2 = (zza)this.zzbOF.valueAt(i);
            zza2.zzbOv++;
            if (zza2.zzbOv >= this.zzbOs) {
                zza2.zzbOr.onDone();
                hashSet.add(n);
                continue;
            }
            zza2.zzbOr.onMissing(detections);
        }
        for (Integer n : hashSet) {
            this.zzbOF.delete(n.intValue());
        }
    }

    private void zzc(Detector.Detections<T> detections) {
        SparseArray<T> sparseArray = detections.getDetectedItems();
        for (int i = 0; i < sparseArray.size(); ++i) {
            int n = sparseArray.keyAt(i);
            Object object = sparseArray.valueAt(i);
            zza zza2 = (zza)this.zzbOF.get(n);
            zza2.zzbOv = 0;
            zza2.zzbOr.onUpdate(detections, object);
        }
    }

    private class zza {
        private Tracker<T> zzbOr;
        private int zzbOv = 0;

        private zza(MultiProcessor multiProcessor) {
        }
    }

    public static class Builder<T> {
        private MultiProcessor<T> zzbOG = new MultiProcessor();

        public Builder(Factory<T> factory) {
            if (factory == null) {
                throw new IllegalArgumentException("No factory supplied.");
            }
            ((MultiProcessor)this.zzbOG).zzbOE = factory;
        }

        public Builder<T> setMaxGapFrames(int n) {
            if (n < 0) {
                throw new IllegalArgumentException(new StringBuilder(28).append("Invalid max gap: ").append(n).toString());
            }
            ((MultiProcessor)this.zzbOG).zzbOs = n;
            return this;
        }

        public MultiProcessor<T> build() {
            return this.zzbOG;
        }
    }

    public static interface Factory<T> {
        public Tracker<T> create(T var1);
    }
}

