/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.zzbka;
import com.google.android.gms.internal.zzbkc;
import com.google.android.gms.internal.zzbkh;
import com.google.android.gms.internal.zzbkj;
import com.google.android.gms.internal.zzbkn;
import com.google.android.gms.internal.zzbko;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final zzbkn zzbPw;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(zzbkn zzbkn2) {
        this.zzbPw = zzbkn2;
    }

    @Override
    public SparseArray<TextBlock> detect(Frame frame) {
        return this.zza(frame, new zzbkj(1, new Rect()));
    }

    public SparseArray<TextBlock> zza(Frame frame, zzbkj zzbkj2) {
        Frame.Metadata metadata;
        Bitmap bitmap;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        zzbka zzbka2 = zzbka.zzc(frame);
        if (frame.getBitmap() != null) {
            bitmap = frame.getBitmap();
        } else {
            metadata = frame.getMetadata();
            bitmap = this.zza(frame.getGrayscaleImageData(), metadata.getFormat(), zzbka2.width, zzbka2.height);
        }
        bitmap = zzbkc.zzb(bitmap, zzbka2);
        if (!zzbkj2.zzbPJ.isEmpty()) {
            metadata = this.zza(zzbkj2.zzbPJ, frame.getMetadata().getWidth(), frame.getMetadata().getHeight(), zzbka2);
            zzbkj2.zzbPJ.set((Rect)metadata);
        }
        zzbka2.rotation = 0;
        return this.zza(this.zzbPw.zza(bitmap, zzbka2, zzbkj2));
    }

    private Bitmap zza(ByteBuffer byteBuffer, int n, int n2, int n3) {
        byte[] byArray;
        if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
            byArray = byteBuffer.array();
        } else {
            byArray = new byte[byteBuffer.capacity()];
            byteBuffer.get(byArray);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        YuvImage yuvImage = new YuvImage(byArray, n, n2, n3, null);
        yuvImage.compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        return BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
    }

    private Rect zza(Rect rect, int n, int n2, zzbka zzbka2) {
        switch (zzbka2.rotation) {
            case 1: {
                return new Rect(n2 - rect.bottom, rect.left, n2 - rect.top, rect.right);
            }
            case 2: {
                return new Rect(n - rect.right, n2 - rect.bottom, n - rect.left, n2 - rect.top);
            }
            case 3: {
                return new Rect(rect.top, n - rect.right, rect.bottom, n - rect.left);
            }
        }
        return rect;
    }

    private SparseArray<TextBlock> zza(zzbkh[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (zzbkh zzbkh2 : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(zzbkh2.zzbPH);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(zzbkh2.zzbPH, (Object)sparseArray3);
            }
            sparseArray3.append(zzbkh2.zzbPI, (Object)zzbkh2);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<zzbkh>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    @Override
    public boolean isOperational() {
        return this.zzbPw.isOperational();
    }

    @Override
    public void release() {
        super.release();
        this.zzbPw.zzTT();
    }

    public static class Builder {
        private Context mContext;
        private zzbko zzbPx;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbPx = new zzbko();
        }

        public TextRecognizer build() {
            zzbkn zzbkn2 = new zzbkn(this.mContext, this.zzbPx);
            return new TextRecognizer(zzbkn2);
        }
    }
}

