/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.gq;
import com.google.android.gms.internal.gw;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private gw[] zzbNS;
    private Point[] cornerPoints;
    private List<Line> zzbNT;
    private String zzbNU;
    private Rect zzbNV;

    TextBlock(SparseArray<gw> sparseArray) {
        this.zzbNS = new gw[sparseArray.size()];
        for (int i = 0; i < this.zzbNS.length; ++i) {
            this.zzbNS[i] = (gw)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzbNU != null) {
            return this.zzbNU;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        gw[] gwArray = this.zzbNS;
        int n = this.zzbNS.length;
        for (int i = 0; i < n; ++i) {
            gw gw2 = gwArray[i];
            int n2 = 0;
            if (hashMap.containsKey(gw2.zzbNU)) {
                n2 = (Integer)hashMap.get(gw2.zzbNU);
            }
            hashMap.put(gw2.zzbNU, n2 + 1);
        }
        this.zzbNU = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzbNU == null || this.zzbNU.isEmpty()) {
            this.zzbNU = "und";
        }
        return this.zzbNU;
    }

    @Override
    public String getValue() {
        if (this.zzbNS.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzbNS[0].zzbOd);
        for (int i = 1; i < this.zzbNS.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzbNS[i].zzbOd);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, gq gq2) {
        int n5 = gq2.left;
        int n6 = gq2.top;
        double d = Math.sin(Math.toRadians(gq2.zzbNY));
        double d2 = Math.cos(Math.toRadians(gq2.zzbNY));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzbNS.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzbNS.length; ++i) {
                    gq gq2 = textBlock.zzbNS[0].zzbOa;
                    gq gq3 = textBlock.zzbNS[i].zzbOa;
                    int n5 = -gq2.left;
                    int n6 = -gq2.top;
                    double d = Math.sin(Math.toRadians(gq2.zzbNY));
                    double d2 = Math.cos(Math.toRadians(gq2.zzbNY));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(gq3.left, gq3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + gq3.width, n8);
                    pointArray2[2] = new Point(n7 + gq3.width, n8 + gq3.height);
                    pointArray2[3] = new Point(n7, n8 + gq3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzbNS[0].zzbOa);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzbNS.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzbNT == null) {
            textBlock.zzbNT = new ArrayList<Line>(textBlock.zzbNS.length);
            gw[] gwArray = textBlock.zzbNS;
            int n = textBlock.zzbNS.length;
            for (int i = 0; i < n; ++i) {
                gw gw2 = gwArray[i];
                textBlock.zzbNT.add(new Line(gw2));
            }
        }
        return textBlock.zzbNT;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzbNV == null) {
            this.zzbNV = zzc.zza(this);
        }
        return this.zzbNV;
    }
}

