/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.graphics.Point;
import android.graphics.Rect;
import android.util.SparseArray;
import com.google.android.gms.internal.fd;
import com.google.android.gms.internal.fj;
import com.google.android.gms.vision.text.Line;
import com.google.android.gms.vision.text.Text;
import com.google.android.gms.vision.text.zza;
import com.google.android.gms.vision.text.zzc;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

public class TextBlock
implements Text {
    private fj[] zzbNO;
    private Point[] cornerPoints;
    private List<Line> zzbNP;
    private String zzbNQ;
    private Rect zzbNR;

    TextBlock(SparseArray<fj> sparseArray) {
        this.zzbNO = new fj[sparseArray.size()];
        for (int i = 0; i < this.zzbNO.length; ++i) {
            this.zzbNO[i] = (fj)((Object)sparseArray.valueAt(i));
        }
    }

    public String getLanguage() {
        if (this.zzbNQ != null) {
            return this.zzbNQ;
        }
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        fj[] fjArray = this.zzbNO;
        int n = this.zzbNO.length;
        for (int i = 0; i < n; ++i) {
            fj fj2 = fjArray[i];
            int n2 = 0;
            if (hashMap.containsKey(fj2.zzbNQ)) {
                n2 = (Integer)hashMap.get(fj2.zzbNQ);
            }
            hashMap.put(fj2.zzbNQ, n2 + 1);
        }
        this.zzbNQ = Collections.max(hashMap.entrySet(), new zza(this)).getKey();
        if (this.zzbNQ == null || this.zzbNQ.isEmpty()) {
            this.zzbNQ = "und";
        }
        return this.zzbNQ;
    }

    @Override
    public String getValue() {
        if (this.zzbNO.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder(this.zzbNO[0].zzbNZ);
        for (int i = 1; i < this.zzbNO.length; ++i) {
            stringBuilder.append("\n");
            stringBuilder.append(this.zzbNO[i].zzbNZ);
        }
        return stringBuilder.toString();
    }

    private static Point[] zza(int n, int n2, int n3, int n4, fd fd2) {
        int n5 = fd2.left;
        int n6 = fd2.top;
        double d = Math.sin(Math.toRadians(fd2.zzbNU));
        double d2 = Math.cos(Math.toRadians(fd2.zzbNU));
        Point[] pointArray = new Point[4];
        Point[] pointArray2 = pointArray;
        pointArray[0] = new Point(n, n2);
        pointArray2[1] = new Point(n3, n2);
        pointArray2[2] = new Point(n3, n4);
        pointArray2[3] = new Point(n, n4);
        for (int i = 0; i < 4; ++i) {
            int n7 = (int)((double)pointArray2[i].x * d2 - (double)pointArray2[i].y * d);
            int n8 = (int)((double)pointArray2[i].x * d + (double)pointArray2[i].y * d2);
            pointArray2[i].x = n7;
            pointArray2[i].y = n8;
            pointArray2[i].offset(n5, n6);
        }
        return pointArray2;
    }

    @Override
    public Point[] getCornerPoints() {
        if (this.cornerPoints == null) {
            TextBlock textBlock = this;
            if (textBlock.zzbNO.length == 0) {
                textBlock.cornerPoints = new Point[0];
            } else {
                int n = Integer.MAX_VALUE;
                int n2 = Integer.MIN_VALUE;
                int n3 = Integer.MAX_VALUE;
                int n4 = Integer.MIN_VALUE;
                for (int i = 0; i < textBlock.zzbNO.length; ++i) {
                    fd fd2 = textBlock.zzbNO[0].zzbNW;
                    fd fd3 = textBlock.zzbNO[i].zzbNW;
                    int n5 = -fd2.left;
                    int n6 = -fd2.top;
                    double d = Math.sin(Math.toRadians(fd2.zzbNU));
                    double d2 = Math.cos(Math.toRadians(fd2.zzbNU));
                    Point[] pointArray = new Point[4];
                    Point[] pointArray2 = pointArray;
                    pointArray[0] = new Point(fd3.left, fd3.top);
                    pointArray2[0].offset(n5, n6);
                    int n7 = (int)((double)pointArray2[0].x * d2 + (double)pointArray2[0].y * d);
                    int n8 = (int)((double)(-pointArray2[0].x) * d + (double)pointArray2[0].y * d2);
                    pointArray2[0].x = n7;
                    pointArray2[0].y = n8;
                    pointArray2[1] = new Point(n7 + fd3.width, n8);
                    pointArray2[2] = new Point(n7 + fd3.width, n8 + fd3.height);
                    pointArray2[3] = new Point(n7, n8 + fd3.height);
                    Point[] pointArray3 = pointArray2;
                    for (int j = 0; j < 4; ++j) {
                        Point point = pointArray3[j];
                        n = Math.min(n, point.x);
                        n2 = Math.max(n2, point.x);
                        n3 = Math.min(n3, point.y);
                        n4 = Math.max(n4, point.y);
                    }
                }
                textBlock.cornerPoints = TextBlock.zza(n, n3, n2, n4, textBlock.zzbNO[0].zzbNW);
            }
        }
        return this.cornerPoints;
    }

    @Override
    public List<? extends Text> getComponents() {
        TextBlock textBlock = this;
        if (textBlock.zzbNO.length == 0) {
            return new ArrayList(0);
        }
        if (textBlock.zzbNP == null) {
            textBlock.zzbNP = new ArrayList<Line>(textBlock.zzbNO.length);
            fj[] fjArray = textBlock.zzbNO;
            int n = textBlock.zzbNO.length;
            for (int i = 0; i < n; ++i) {
                fj fj2 = fjArray[i];
                textBlock.zzbNP.add(new Line(fj2));
            }
        }
        return textBlock.zzbNP;
    }

    @Override
    public Rect getBoundingBox() {
        if (this.zzbNR == null) {
            this.zzbNR = zzc.zza(this);
        }
        return this.zzbNR;
    }
}

