/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.barcode;

import android.content.Context;
import android.util.SparseArray;
import com.google.android.gms.internal.et;
import com.google.android.gms.internal.ev;
import com.google.android.gms.internal.fb;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.barcode.Barcode;
import com.google.android.gms.vision.barcode.zzc;
import java.nio.ByteBuffer;

public final class BarcodeDetector
extends Detector<Barcode> {
    private final ev zzbNe;

    private BarcodeDetector() {
        throw new IllegalStateException("Default constructor called");
    }

    private BarcodeDetector(ev ev2) {
        this.zzbNe = ev2;
    }

    public final void release() {
        super.release();
        this.zzbNe.zzDP();
    }

    public final SparseArray<Barcode> detect(Frame frame) {
        ByteBuffer byteBuffer;
        Barcode[] barcodeArray;
        if (frame == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        fb fb2 = fb.zzc((Frame)frame);
        if (frame.getBitmap() != null) {
            barcodeArray = this.zzbNe.zza(frame.getBitmap(), fb2);
            if (barcodeArray == null) {
                throw new IllegalArgumentException("Internal barcode detector error; check logcat output.");
            }
        } else {
            byteBuffer = frame.getGrayscaleImageData();
            barcodeArray = this.zzbNe.zza(byteBuffer, fb2);
        }
        byteBuffer = new SparseArray(barcodeArray.length);
        Barcode[] barcodeArray2 = barcodeArray;
        int n = barcodeArray.length;
        for (int i = 0; i < n; ++i) {
            Barcode barcode = barcodeArray2[i];
            byteBuffer.append(barcode.rawValue.hashCode(), (Object)barcode);
        }
        return byteBuffer;
    }

    public final boolean isOperational() {
        return this.zzbNe.isOperational();
    }

    /* synthetic */ BarcodeDetector(ev ev2, zzc zzc2) {
        this(ev2);
    }

    public static class Builder {
        private Context mContext;
        private et zzbNf;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbNf = new et();
        }

        public Builder setBarcodeFormats(int n) {
            this.zzbNf.zzbNg = n;
            return this;
        }

        public BarcodeDetector build() {
            ev ev2 = new ev(this.mContext, this.zzbNf);
            return new BarcodeDetector(ev2, null);
        }
    }
}

