/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.gms.vision.text;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.util.SparseArray;
import com.google.android.gms.internal.fb;
import com.google.android.gms.internal.fj;
import com.google.android.gms.internal.fl;
import com.google.android.gms.internal.fp;
import com.google.android.gms.internal.fq;
import com.google.android.gms.vision.Detector;
import com.google.android.gms.vision.Frame;
import com.google.android.gms.vision.text.TextBlock;
import com.google.android.gms.vision.text.zzb;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;

public final class TextRecognizer
extends Detector<TextBlock> {
    private final fp zzbNS;

    private TextRecognizer() {
        throw new IllegalStateException("Default constructor called");
    }

    private TextRecognizer(fp fp2) {
        this.zzbNS = fp2;
    }

    public final SparseArray<TextBlock> detect(Frame frame) {
        ByteBuffer byteBuffer;
        int n;
        int n2;
        Object object;
        Bitmap bitmap;
        fl fl2 = new fl(new Rect());
        Frame frame2 = frame;
        TextRecognizer textRecognizer = this;
        if (frame2 == null) {
            throw new IllegalArgumentException("No frame supplied.");
        }
        fb fb2 = fb.zzc((Frame)frame2);
        if (frame2.getBitmap() != null) {
            bitmap = frame2.getBitmap();
        } else {
            byte[] byArray;
            object = frame2.getMetadata();
            int n3 = fb2.height;
            n2 = fb2.width;
            n = object.getFormat();
            byteBuffer = frame2.getGrayscaleImageData();
            if (byteBuffer.hasArray() && byteBuffer.arrayOffset() == 0) {
                byArray = byteBuffer.array();
            } else {
                byArray = new byte[byteBuffer.capacity()];
                byteBuffer.get(byArray);
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new YuvImage(byArray, n, n2, n3, null).compressToJpeg(new Rect(0, 0, n2, n3), 100, (OutputStream)byteArrayOutputStream);
            byte[] byArray2 = byteArrayOutputStream.toByteArray();
            bitmap = BitmapFactory.decodeByteArray((byte[])byArray2, (int)0, (int)byArray2.length);
        }
        fb fb3 = fb2;
        Bitmap bitmap2 = bitmap;
        int n4 = bitmap2.getWidth();
        int n5 = bitmap2.getHeight();
        if (fb3.rotation != 0) {
            int n6;
            Matrix matrix = new Matrix();
            switch (fb3.rotation) {
                case 0: {
                    n6 = 0;
                    break;
                }
                case 1: {
                    n6 = 90;
                    break;
                }
                case 2: {
                    n6 = 180;
                    break;
                }
                case 3: {
                    n6 = 270;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported rotation degree.");
                }
            }
            matrix.postRotate((float)n6);
            bitmap2 = Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n4, (int)n5, (Matrix)matrix, (boolean)false);
        }
        if (fb3.rotation == 1 || fb3.rotation == 3) {
            fb3.width = n5;
            fb3.height = n4;
        }
        bitmap = bitmap2;
        if (!fl2.zzbOf.isEmpty()) {
            ByteBuffer byteBuffer2;
            fb fb4 = fb2;
            n2 = frame2.getMetadata().getHeight();
            n = frame2.getMetadata().getWidth();
            byteBuffer = fl2.zzbOf;
            switch (fb4.rotation) {
                case 1: {
                    byteBuffer2 = new Rect(n2 - ((Rect)byteBuffer).bottom, ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top, ((Rect)byteBuffer).right);
                    break;
                }
                case 2: {
                    byteBuffer2 = new Rect(n - ((Rect)byteBuffer).right, n2 - ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left, n2 - ((Rect)byteBuffer).top);
                    break;
                }
                case 3: {
                    byteBuffer2 = new Rect(((Rect)byteBuffer).top, n - ((Rect)byteBuffer).right, ((Rect)byteBuffer).bottom, n - ((Rect)byteBuffer).left);
                    break;
                }
                default: {
                    byteBuffer2 = byteBuffer;
                }
            }
            object = byteBuffer2;
            fl2.zzbOf.set((Rect)object);
        }
        fb2.rotation = 0;
        return TextRecognizer.zza(textRecognizer.zzbNS.zza(bitmap, fb2, fl2));
    }

    private static SparseArray<TextBlock> zza(fj[] sparseArray) {
        SparseArray sparseArray2 = new SparseArray();
        for (fj fj2 : sparseArray) {
            SparseArray sparseArray3 = (SparseArray)sparseArray2.get(fj2.zzbOd);
            if (sparseArray3 == null) {
                sparseArray3 = new SparseArray();
                sparseArray2.append(fj2.zzbOd, (Object)sparseArray3);
            }
            sparseArray3.append(fj2.zzbOe, (Object)fj2);
        }
        SparseArray sparseArray4 = new SparseArray(sparseArray2.size());
        for (int i = 0; i < sparseArray2.size(); ++i) {
            sparseArray4.append(sparseArray2.keyAt(i), (Object)new TextBlock((SparseArray<fj>)((SparseArray)sparseArray2.valueAt(i))));
        }
        return sparseArray4;
    }

    public final boolean isOperational() {
        return this.zzbNS.isOperational();
    }

    public final void release() {
        super.release();
        this.zzbNS.zzDP();
    }

    /* synthetic */ TextRecognizer(fp fp2, zzb zzb2) {
        this(fp2);
    }

    public static class Builder {
        private Context mContext;
        private fq zzbNT;

        public Builder(Context context) {
            this.mContext = context;
            this.zzbNT = new fq();
        }

        public TextRecognizer build() {
            fp fp2 = new fp(this.mContext, this.zzbNT);
            return new TextRecognizer(fp2, null);
        }
    }
}

